/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HtmlDomUtil {
    public static final String ENC = "UTF-8";
    public static final String HTML_STRICT = "-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd";

    public static byte[] toUTF8(Document hostDoc) throws IOException {
        return HtmlDomUtil.toString(hostDoc).getBytes(ENC);
    }

    public static byte[] compress(byte[] raw) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gz = new GZIPOutputStream(out);
        gz.write(raw);
        gz.finish();
        gz.flush();
        return out.toByteArray();
    }

    public static String toString(Document hostDoc) throws IOException {
        try {
            StringWriter out = new StringWriter();
            DOMSource domSource = new DOMSource(hostDoc);
            StreamResult streamResult = new StreamResult(out);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", ENC);
            serializer.setOutputProperty("method", "html");
            serializer.setOutputProperty("indent", "no");
            serializer.setOutputProperty("doctype-public", HTML_STRICT);
            serializer.transform(domSource, streamResult);
            return out.toString();
        }
        catch (TransformerConfigurationException e) {
            IOException r = new IOException("Error transforming page");
            r.initCause(e);
            throw r;
        }
        catch (TransformerException e) {
            IOException r = new IOException("Error transforming page");
            r.initCause(e);
            throw r;
        }
    }

    public static Element find(Node parent, String name) {
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element e;
            Node n = list.item(i);
            if (n instanceof Element && name.equals((e = (Element)n).getAttribute("id"))) {
                return e;
            }
            Element r = HtmlDomUtil.find(n, name);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public static void addHidden(Element form, String name, String value) {
        Element in = form.getOwnerDocument().createElement("input");
        in.setAttribute("type", "hidden");
        in.setAttribute("name", name);
        in.setAttribute("value", value);
        form.appendChild(in);
    }

    public static Document newDocument() {
        try {
            return HtmlDomUtil.newBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Cannot create new document", e);
        }
    }

    public static Document clone(Document doc) throws IOException {
        Document d;
        try {
            d = HtmlDomUtil.newBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Cannot clone document");
        }
        Node n = d.importNode(doc.getDocumentElement(), true);
        d.appendChild(n);
        return d;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document parseFile(Class<?> context, String name) throws IOException {
        InputStream in = context.getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        try {
            try {
                Document doc = HtmlDomUtil.newBuilder().parse(in);
                HtmlDomUtil.compact(doc);
                Document document = doc;
                return document;
            }
            catch (SAXException e) {
                throw new IOException("Error reading " + name, e);
            }
            catch (ParserConfigurationException e) {
                throw new IOException("Error reading " + name, e);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            throw new IOException("Error reading " + name, e);
        }
    }

    private static void compact(Document doc) {
        try {
            String expr = "//text()[normalize-space(.) = '']";
            XPathFactory xp = XPathFactory.newInstance();
            XPathExpression e = xp.newXPath().compile("//text()[normalize-space(.) = '']");
            NodeList empty = (NodeList)e.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < empty.getLength(); ++i) {
                Node node = empty.item(i);
                node.getParentNode().removeChild(node);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }

    public static String readFile(Class<?> context, String name) throws IOException {
        InputStream in = context.getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        try {
            return HtmlDomUtil.asString(in);
        }
        catch (IOException e) {
            throw new IOException("Error reading " + name, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document parseFile(File path) throws IOException {
        try (FileInputStream in = new FileInputStream(path);){
            Document doc = HtmlDomUtil.newBuilder().parse(in);
            HtmlDomUtil.compact(doc);
            Document document = doc;
            return document;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            throw new IOException("Error reading " + path, e);
        }
    }

    public static String readFile(File parentDir, String name) throws IOException {
        if (parentDir == null) {
            return null;
        }
        File path = new File(parentDir, name);
        try {
            return HtmlDomUtil.asString(new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            throw new IOException("Error reading " + path, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String asString(InputStream in) throws UnsupportedEncodingException, IOException {
        try {
            int n;
            StringBuilder w = new StringBuilder();
            InputStreamReader r = new InputStreamReader(in, ENC);
            char[] buf = new char[512];
            while ((n = r.read(buf)) > 0) {
                w.append(buf, 0, n);
            }
            String string = w.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    private static DocumentBuilder newBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setExpandEntityReferences(false);
        factory.setIgnoringComments(true);
        factory.setCoalescing(true);
        return factory.newDocumentBuilder();
    }
}

