/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.httpd.CanonicalWebUrl;
import com.google.gerrit.server.config.CanonicalWebUrlProvider;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jgit.lib.Config;

public class HttpCanonicalWebUrlProvider
extends CanonicalWebUrlProvider {
    private Provider<HttpServletRequest> requestProvider;

    @Inject
    HttpCanonicalWebUrlProvider(@GerritServerConfig Config config) {
        super(config);
    }

    @Inject(optional=true)
    public void setHttpServletRequest(Provider<HttpServletRequest> hsr) {
        this.requestProvider = hsr;
    }

    @Override
    public String get() {
        String canonicalUrl = super.get();
        if (canonicalUrl != null) {
            return canonicalUrl;
        }
        if (this.requestProvider != null) {
            HttpServletRequest req;
            try {
                req = this.requestProvider.get();
            }
            catch (ProvisionException noWeb) {
                if (noWeb.getCause() instanceof OutOfScopeException) {
                    return null;
                }
                throw noWeb;
            }
            return CanonicalWebUrl.computeFromRequest(req);
        }
        return null;
    }
}

