/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.base.Strings;
import com.google.gerrit.common.PageLinks;
import com.google.gerrit.httpd.DirectChangeByCommit;
import com.google.gerrit.httpd.GerritUiOptions;
import com.google.gerrit.httpd.HttpLogoutServlet;
import com.google.gerrit.httpd.RequireIdentifiedUserFilter;
import com.google.gerrit.httpd.raw.CatServlet;
import com.google.gerrit.httpd.raw.HostPageServlet;
import com.google.gerrit.httpd.raw.LegacyGerritServlet;
import com.google.gerrit.httpd.raw.RobotsServlet;
import com.google.gerrit.httpd.raw.SshInfoServlet;
import com.google.gerrit.httpd.raw.StaticServlet;
import com.google.gerrit.httpd.raw.ToolServlet;
import com.google.gerrit.httpd.rpc.access.AccessRestApiServlet;
import com.google.gerrit.httpd.rpc.account.AccountsRestApiServlet;
import com.google.gerrit.httpd.rpc.change.ChangesRestApiServlet;
import com.google.gerrit.httpd.rpc.change.DeprecatedChangeQueryServlet;
import com.google.gerrit.httpd.rpc.config.ConfigRestApiServlet;
import com.google.gerrit.httpd.rpc.doc.QueryDocumentationFilter;
import com.google.gerrit.httpd.rpc.group.GroupsRestApiServlet;
import com.google.gerrit.httpd.rpc.project.ProjectsRestApiServlet;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gwtexpui.server.CacheControlFilter;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.servlet.ServletModule;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.Config;

class UrlModule
extends ServletModule {
    private final UrlConfig cfg;
    private GerritUiOptions uiOptions;

    UrlModule(UrlConfig cfg, GerritUiOptions uiOptions) {
        this.cfg = cfg;
        this.uiOptions = uiOptions;
    }

    @Override
    protected void configureServlets() {
        this.filter("/*", new String[0]).through(Key.get(CacheControlFilter.class));
        this.bind(Key.get(CacheControlFilter.class)).in(Scopes.SINGLETON);
        if (this.uiOptions.enableDefaultUi()) {
            this.serve("/", new String[0]).with(HostPageServlet.class);
            this.serve("/Gerrit", new String[0]).with(LegacyGerritServlet.class);
            this.serve("/Gerrit/*", new String[0]).with(this.legacyGerritScreen());
        }
        this.serve("/cat/*", new String[0]).with(CatServlet.class);
        this.serve("/logout", new String[0]).with(HttpLogoutServlet.class);
        this.serve("/signout", new String[0]).with(HttpLogoutServlet.class);
        this.serve("/ssh_info", new String[0]).with(SshInfoServlet.class);
        this.serve("/static/*", new String[0]).with(StaticServlet.class);
        this.serve("/Main.class", new String[0]).with(this.notFound());
        this.serve("/com/google/gerrit/launcher/*", new String[0]).with(this.notFound());
        this.serve("/servlet/*", new String[0]).with(this.notFound());
        this.serve("/all", new String[0]).with(this.query("status:merged"));
        this.serve("/mine", new String[0]).with(this.screen("/"));
        this.serve("/open", new String[0]).with(this.query("status:open"));
        this.serve("/watched", new String[0]).with(this.query("is:watched status:open"));
        this.serve("/starred", new String[0]).with(this.query("is:starred"));
        this.serveRegex("^/settings/?$", new String[0]).with(this.screen("/settings/"));
        this.serveRegex("^/register/?$", new String[0]).with(this.screen("/register/"));
        this.serveRegex("^/([1-9][0-9]*)/?$", new String[0]).with(this.directChangeById());
        this.serveRegex("^/p/(.*)$", new String[0]).with(this.queryProjectNew());
        this.serveRegex("^/r/(.+)/?$", new String[0]).with(DirectChangeByCommit.class);
        this.filter("/a/*", new String[0]).through(RequireIdentifiedUserFilter.class);
        this.serveRegex("^/(?:a/)?tools/(.*)$", new String[0]).with(ToolServlet.class);
        this.serveRegex("^/(?:a/)?access/(.*)$", new String[0]).with(AccessRestApiServlet.class);
        this.serveRegex("^/(?:a/)?accounts/(.*)$", new String[0]).with(AccountsRestApiServlet.class);
        this.serveRegex("^/(?:a/)?changes/(.*)$", new String[0]).with(ChangesRestApiServlet.class);
        this.serveRegex("^/(?:a/)?config/(.*)$", new String[0]).with(ConfigRestApiServlet.class);
        this.serveRegex("^/(?:a/)?groups/(.*)?$", new String[0]).with(GroupsRestApiServlet.class);
        this.serveRegex("^/(?:a/)?projects/(.*)?$", new String[0]).with(ProjectsRestApiServlet.class);
        this.filter("/Documentation/", new String[0]).through(QueryDocumentationFilter.class);
        if (this.cfg.deprecatedQuery) {
            this.serve("/query", new String[0]).with(DeprecatedChangeQueryServlet.class);
        }
        this.serve("/robots.txt", new String[0]).with(RobotsServlet.class);
    }

    private Key<HttpServlet> notFound() {
        return this.key(new HttpServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
                rsp.sendError(404);
            }
        });
    }

    private Key<HttpServlet> screen(final String target) {
        return this.key(new HttpServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
                UrlModule.toGerrit(target, req, rsp);
            }
        });
    }

    private Key<HttpServlet> legacyGerritScreen() {
        return this.key(new HttpServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
                String token = req.getPathInfo().substring(1);
                UrlModule.toGerrit(token, req, rsp);
            }
        });
    }

    private Key<HttpServlet> directChangeById() {
        return this.key(new HttpServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
                try {
                    String idString = req.getPathInfo();
                    if (idString.endsWith("/")) {
                        idString = idString.substring(0, idString.length() - 1);
                    }
                    Change.Id id = Change.Id.parse(idString);
                    UrlModule.toGerrit(PageLinks.toChange(id), req, rsp);
                }
                catch (IllegalArgumentException err) {
                    rsp.sendError(404);
                }
            }
        });
    }

    private Key<HttpServlet> queryProjectNew() {
        return this.key(new HttpServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
                String name = req.getPathInfo();
                if (Strings.isNullOrEmpty(name)) {
                    UrlModule.toGerrit("/admin/projects/", req, rsp);
                    return;
                }
                while (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                if (name.endsWith(".git")) {
                    name = name.substring(0, name.length() - ".git".length());
                }
                while (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                Project.NameKey project = new Project.NameKey(name);
                UrlModule.toGerrit(PageLinks.toChangeQuery(PageLinks.projectQuery(project, Change.Status.NEW)), req, rsp);
            }
        });
    }

    private Key<HttpServlet> query(final String query) {
        return this.key(new HttpServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
                UrlModule.toGerrit(PageLinks.toChangeQuery(query), req, rsp);
            }
        });
    }

    private Key<HttpServlet> key(final HttpServlet servlet) {
        Key<HttpServlet> srv = Key.get(HttpServlet.class, UniqueAnnotations.create());
        this.bind(srv).toProvider(new Provider<HttpServlet>(){

            @Override
            public HttpServlet get() {
                return servlet;
            }
        }).in(Scopes.SINGLETON);
        return srv;
    }

    static void toGerrit(String target, HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        StringBuilder url = new StringBuilder();
        url.append(req.getContextPath());
        url.append('/');
        url.append('#');
        url.append(target);
        rsp.sendRedirect(url.toString());
    }

    static class UrlConfig {
        private final boolean deprecatedQuery;

        @Inject
        UrlConfig(@GerritServerConfig Config cfg) {
            this.deprecatedQuery = cfg.getBoolean("site", "enableDeprecatedQuery", true);
        }
    }
}

