/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.auth.container;

import com.google.gerrit.httpd.CanonicalWebUrl;
import com.google.gerrit.httpd.HtmlDomUtil;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.httpd.auth.container.HttpAuthFilter;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.AuthResult;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Singleton
class HttpLoginServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(HttpLoginServlet.class);
    private final Provider<WebSession> webSession;
    private final CanonicalWebUrl urlProvider;
    private final AccountManager accountManager;
    private final HttpAuthFilter authFilter;
    private final AuthConfig authConfig;

    @Inject
    HttpLoginServlet(Provider<WebSession> webSession, CanonicalWebUrl urlProvider, AccountManager accountManager, HttpAuthFilter authFilter, AuthConfig authConfig) {
        this.webSession = webSession;
        this.urlProvider = urlProvider;
        this.accountManager = accountManager;
        this.authFilter = authFilter;
        this.authConfig = authConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        AuthResult arsp;
        String token = this.getToken(req);
        if ("/logout".equals(token) || "/signout".equals(token)) {
            req.getRequestDispatcher("/logout").forward(req, rsp);
            return;
        }
        CacheHeaders.setNotCacheable(rsp);
        String user = this.authFilter.getRemoteUser(req);
        if (user == null || "".equals(user)) {
            log.error("Unable to authenticate user by " + this.authFilter.getLoginHeader() + " request header.  Check container or server configuration.");
            Document doc = HtmlDomUtil.parseFile(HttpLoginServlet.class, "ConfigurationError.html");
            this.replace(doc, "loginHeader", this.authFilter.getLoginHeader());
            this.replace(doc, "ServerName", req.getServerName());
            this.replace(doc, "ServerPort", ":" + req.getServerPort());
            this.replace(doc, "ContextPath", req.getContextPath());
            byte[] bin = HtmlDomUtil.toUTF8(doc);
            rsp.setStatus(403);
            rsp.setContentType("text/html");
            rsp.setCharacterEncoding("UTF-8");
            rsp.setContentLength(bin.length);
            ServletOutputStream out = rsp.getOutputStream();
            try {
                out.write(bin);
            }
            finally {
                out.flush();
                out.close();
            }
            return;
        }
        AuthRequest areq = AuthRequest.forUser(user);
        areq.setDisplayName(this.authFilter.getRemoteDisplayname(req));
        areq.setEmailAddress(this.authFilter.getRemoteEmail(req));
        try {
            arsp = this.accountManager.authenticate(areq);
        }
        catch (AccountException e) {
            log.error("Unable to authenticate user \"" + user + "\"", e);
            rsp.sendError(403);
            return;
        }
        StringBuilder rdr = new StringBuilder();
        if (arsp.isNew() && this.authConfig.getRegisterPageUrl() != null) {
            rdr.append(this.authConfig.getRegisterPageUrl());
        } else {
            rdr.append(this.urlProvider.get(req));
            rdr.append('#');
            if (arsp.isNew() && !token.startsWith("/register/")) {
                rdr.append("/register");
            }
            rdr.append(token);
        }
        this.webSession.get().login(arsp, true);
        rsp.sendRedirect(rdr.toString());
    }

    private void replace(Document doc, String name, String value) {
        Element e = HtmlDomUtil.find(doc, name);
        if (e != null) {
            e.setTextContent(value);
        } else {
            this.replaceByClass(doc, name, value);
        }
    }

    private void replaceByClass(Node parent, String name, String value) {
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element e;
            Node n = list.item(i);
            if (n instanceof Element && name.equals((e = (Element)n).getAttribute("class"))) {
                e.setTextContent(value);
            }
            this.replaceByClass(n, name, value);
        }
    }

    private String getToken(HttpServletRequest req) {
        String token = req.getPathInfo();
        if (token == null || token.isEmpty()) {
            token = "/";
        } else if (!token.startsWith("/")) {
            token = "/" + token;
        }
        return token;
    }
}

