/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.gitweb;

import com.google.gerrit.httpd.GitWebConfig;
import com.google.gerrit.httpd.HtmlDomUtil;
import com.google.gerrit.server.config.SitePaths;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.gwtjsonrpc.server.RPCServletUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

abstract class GitWebCssServlet
extends HttpServlet {
    private static final String ENC = "UTF-8";
    private final long modified;
    private final byte[] raw_css;
    private final byte[] gz_css;

    GitWebCssServlet(File src, GitWebConfig gitWebConfig) throws IOException {
        if (src != null) {
            String name;
            File dir = src.getParentFile();
            String raw = HtmlDomUtil.readFile(dir, name = src.getName());
            if (raw != null) {
                this.modified = src.lastModified();
                this.raw_css = raw.getBytes(ENC);
                this.gz_css = HtmlDomUtil.compress(this.raw_css);
            } else {
                this.modified = -1L;
                this.raw_css = null;
                this.gz_css = null;
            }
        } else {
            this.modified = -1L;
            this.raw_css = null;
            this.gz_css = null;
        }
    }

    @Override
    protected long getLastModified(HttpServletRequest req) {
        return this.modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        if (this.raw_css != null) {
            byte[] toSend;
            rsp.setContentType("text/css");
            rsp.setCharacterEncoding(ENC);
            if (RPCServletUtils.acceptsGzipEncoding(req)) {
                rsp.setHeader("Content-Encoding", "gzip");
                toSend = this.gz_css;
            } else {
                toSend = this.raw_css;
            }
            rsp.setContentLength(toSend.length);
            rsp.setDateHeader("Last-Modified", this.modified);
            CacheHeaders.setCacheable(req, rsp, 5L, TimeUnit.MINUTES);
            try (ServletOutputStream os = rsp.getOutputStream();){
                os.write(toSend);
            }
        } else {
            CacheHeaders.setNotCacheable(rsp);
            rsp.sendError(404);
        }
    }

    @Singleton
    static class Default
    extends GitWebCssServlet {
        @Inject
        Default(GitWebConfig gwc) throws IOException {
            super(gwc.getGitwebCSS(), gwc);
        }
    }

    @Singleton
    static class Site
    extends GitWebCssServlet {
        @Inject
        Site(SitePaths paths, GitWebConfig gwc) throws IOException {
            super(paths.site_css, gwc);
        }
    }
}

