/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.plugins;

import com.google.common.base.Strings;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

class ContextMapper {
    private static final String PLUGINS_PREFIX = "/plugins/";
    private static final String AUTHORIZED_PREFIX = "/a/plugins/";
    private final String base;
    private final String authorizedBase;

    public ContextMapper(String contextPath) {
        this.base = Strings.nullToEmpty(contextPath) + PLUGINS_PREFIX;
        this.authorizedBase = Strings.nullToEmpty(contextPath) + AUTHORIZED_PREFIX;
    }

    private static boolean isAuthorizedCall(HttpServletRequest req) {
        return !Strings.isNullOrEmpty(req.getServletPath()) && req.getServletPath().startsWith(AUTHORIZED_PREFIX);
    }

    HttpServletRequest create(HttpServletRequest req, String name) {
        String contextPath = (ContextMapper.isAuthorizedCall(req) ? this.authorizedBase : this.base) + name;
        return new WrappedRequest(req, contextPath);
    }

    public String getFullPath(String name) {
        return this.base + name;
    }

    private class WrappedRequest
    extends HttpServletRequestWrapper {
        private final String contextPath;
        private final String pathInfo;

        private WrappedRequest(HttpServletRequest req, String contextPath) {
            super(req);
            this.contextPath = contextPath;
            this.pathInfo = this.getRequestURI().substring(contextPath.length());
        }

        @Override
        public String getServletPath() {
            return "";
        }

        @Override
        public String getContextPath() {
            return this.contextPath;
        }

        @Override
        public String getPathInfo() {
            return this.pathInfo;
        }
    }
}

