/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.plugins;

import com.google.common.collect.Maps;
import com.google.gerrit.common.Version;
import com.google.gerrit.server.plugins.Plugin;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PluginServletContext {
    private static final Logger log = LoggerFactory.getLogger("plugin");

    static ServletContext create(Plugin plugin, String contextPath) {
        return (ServletContext)Proxy.newProxyInstance(PluginServletContext.class.getClassLoader(), new Class[]{ServletContext.class, API.class}, (InvocationHandler)new Handler(plugin, contextPath));
    }

    private PluginServletContext() {
    }

    static interface API {
        public String getContextPath();

        public String getInitParameter(String var1);

        public Enumeration getInitParameterNames();

        public ServletContext getContext(String var1);

        public RequestDispatcher getNamedDispatcher(String var1);

        public RequestDispatcher getRequestDispatcher(String var1);

        public URL getResource(String var1);

        public InputStream getResourceAsStream(String var1);

        public Set getResourcePaths(String var1);

        public Servlet getServlet(String var1);

        public String getRealPath(String var1);

        public String getServletContextName();

        public Enumeration getServletNames();

        public Enumeration getServlets();

        public void log(Exception var1, String var2);

        public void log(String var1);

        public void log(String var1, Throwable var2);

        public Object getAttribute(String var1);

        public Enumeration<String> getAttributeNames();

        public void setAttribute(String var1, Object var2);

        public void removeAttribute(String var1);

        public String getMimeType(String var1);

        public int getMajorVersion();

        public int getMinorVersion();

        public String getServerInfo();
    }

    private static class Handler
    implements InvocationHandler,
    API {
        private final Plugin plugin;
        private final String contextPath;
        private final ConcurrentMap<String, Object> attributes;

        Handler(Plugin plugin, String contextPath) {
            this.plugin = plugin;
            this.contextPath = contextPath;
            this.attributes = Maps.newConcurrentMap();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method handler;
            try {
                handler = API.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(String.format("%s does not implement%s", PluginServletContext.class, method.toGenericString()));
            }
            return handler.invoke((Object)this, args);
        }

        @Override
        public String getContextPath() {
            return this.contextPath;
        }

        @Override
        public String getInitParameter(String name) {
            return null;
        }

        @Override
        public Enumeration getInitParameterNames() {
            return Collections.enumeration(Collections.emptyList());
        }

        @Override
        public ServletContext getContext(String name) {
            return null;
        }

        @Override
        public RequestDispatcher getNamedDispatcher(String name) {
            return null;
        }

        @Override
        public RequestDispatcher getRequestDispatcher(String name) {
            return null;
        }

        @Override
        public URL getResource(String name) {
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return null;
        }

        @Override
        public Set getResourcePaths(String name) {
            return null;
        }

        @Override
        public Servlet getServlet(String name) {
            return null;
        }

        @Override
        public String getRealPath(String name) {
            return null;
        }

        @Override
        public String getServletContextName() {
            return this.plugin.getName();
        }

        @Override
        public Enumeration getServletNames() {
            return Collections.enumeration(Collections.emptyList());
        }

        @Override
        public Enumeration getServlets() {
            return Collections.enumeration(Collections.emptyList());
        }

        @Override
        public void log(Exception reason, String msg) {
            this.log(msg, reason);
        }

        @Override
        public void log(String msg) {
            this.log(msg, null);
        }

        @Override
        public void log(String msg, Throwable reason) {
            log.warn(String.format("[plugin %s] %s", this.plugin.getName(), msg), reason);
        }

        @Override
        public Object getAttribute(String name) {
            return this.attributes.get(name);
        }

        @Override
        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this.attributes.keySet());
        }

        @Override
        public void setAttribute(String name, Object value) {
            this.attributes.put(name, value);
        }

        @Override
        public void removeAttribute(String name) {
            this.attributes.remove(name);
        }

        @Override
        public String getMimeType(String file) {
            return null;
        }

        @Override
        public int getMajorVersion() {
            return 2;
        }

        @Override
        public int getMinorVersion() {
            return 5;
        }

        @Override
        public String getServerInfo() {
            String v = Version.getVersion();
            return "Gerrit Code Review/" + (v != null ? v : "dev");
        }
    }
}

