/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.common.io.ByteStreams;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RobotsServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(RobotsServlet.class);
    private final File robotsFile;

    @Inject
    RobotsServlet(@GerritServerConfig Config config, SitePaths sitePaths) {
        File file = sitePaths.resolve(config.getString("httpd", null, "robotsFile"));
        if (!(file == null || file.exists() && file.canRead())) {
            log.warn("Cannot read httpd.robotsFile, using default");
            file = null;
        }
        this.robotsFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        rsp.setContentType("text/plain");
        try (InputStream in = this.openRobotsFile();
             ServletOutputStream out = rsp.getOutputStream();){
            ByteStreams.copy(in, (OutputStream)out);
        }
    }

    private InputStream openRobotsFile() {
        if (this.robotsFile != null) {
            try {
                return new FileInputStream(this.robotsFile);
            }
            catch (IOException e) {
                log.warn("Cannot read " + this.robotsFile + "; using default", e);
            }
        }
        return this.getServletContext().getResourceAsStream("/robots.txt");
    }
}

