/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.gerrit.common.data.HostPageData;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import org.eclipse.jgit.lib.Config;

class ThemeFactory {
    private final Config cfg;

    @Inject
    ThemeFactory(@GerritServerConfig Config cfg) {
        this.cfg = cfg;
    }

    HostPageData.Theme getSignedOutTheme() {
        return this.getTheme("signed-out");
    }

    HostPageData.Theme getSignedInTheme() {
        return this.getTheme("signed-in");
    }

    private HostPageData.Theme getTheme(String name) {
        HostPageData.Theme theme = new HostPageData.Theme();
        theme.backgroundColor = this.color(name, "backgroundColor", "#FFFFFF");
        theme.textColor = this.color(name, "textColor", "#353535");
        theme.trimColor = this.color(name, "trimColor", "#EEEEEE");
        theme.selectionColor = this.color(name, "selectionColor", "#D8EDF9");
        theme.topMenuColor = this.color(name, "topMenuColor", "#FFFFFF");
        theme.changeTableOutdatedColor = this.color(name, "changeTableOutdatedColor", "#F08080");
        theme.tableOddRowColor = this.color(name, "tableOddRowColor", "transparent");
        theme.tableEvenRowColor = this.color(name, "tableEvenRowColor", "transparent");
        return theme;
    }

    private String color(String section, String name, String defaultValue) {
        String v = this.cfg.getString("theme", section, name);
        if ((v == null || v.isEmpty()) && ((v = this.cfg.getString("theme", null, name)) == null || v.isEmpty())) {
            v = defaultValue;
        }
        if (!v.startsWith("#") && v.matches("^[0-9a-fA-F]{2,6}$")) {
            v = "#" + v;
        }
        return v;
    }
}

