/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc;

import com.google.gerrit.common.errors.CorruptEntityException;
import com.google.gerrit.common.errors.InvalidQueryException;
import com.google.gerrit.common.errors.NoSuchEntityException;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gwtjsonrpc.common.AsyncCallback;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.OrmRuntimeException;
import com.google.inject.Provider;

public class BaseServiceImplementation {
    private final Provider<ReviewDb> schema;
    private final Provider<? extends CurrentUser> currentUser;

    protected BaseServiceImplementation(Provider<ReviewDb> schema, Provider<? extends CurrentUser> currentUser) {
        this.schema = schema;
        this.currentUser = currentUser;
    }

    protected Account.Id getAccountId() {
        CurrentUser u = this.currentUser.get();
        if (u.isIdentifiedUser()) {
            return ((IdentifiedUser)u).getAccountId();
        }
        return null;
    }

    protected CurrentUser getCurrentUser() {
        return this.currentUser.get();
    }

    protected <T> void run(AsyncCallback<T> callback, Action<T> action) {
        try {
            T r = action.run(this.schema.get());
            if (r != null) {
                callback.onSuccess(r);
            }
        }
        catch (InvalidQueryException e) {
            callback.onFailure(e);
        }
        catch (NoSuchProjectException e) {
            if (e.getMessage() != null) {
                callback.onFailure(new NoSuchEntityException(e.getMessage()));
            } else {
                callback.onFailure(new NoSuchEntityException());
            }
        }
        catch (NoSuchGroupException e) {
            callback.onFailure(new NoSuchEntityException());
        }
        catch (OrmRuntimeException e) {
            Exception ex = e;
            if (e.getCause() instanceof OrmException) {
                ex = (OrmException)e.getCause();
            }
            BaseServiceImplementation.handleOrmException(callback, ex);
        }
        catch (OrmException e) {
            BaseServiceImplementation.handleOrmException(callback, e);
        }
        catch (Failure e) {
            if (e.getCause() instanceof NoSuchProjectException || e.getCause() instanceof NoSuchChangeException) {
                callback.onFailure(new NoSuchEntityException());
            }
            callback.onFailure(e.getCause());
        }
    }

    private static <T> void handleOrmException(AsyncCallback<T> callback, Exception e) {
        if (e.getCause() instanceof Failure) {
            callback.onFailure(e.getCause().getCause());
        } else if (e.getCause() instanceof CorruptEntityException) {
            callback.onFailure(e.getCause());
        } else if (e.getCause() instanceof NoSuchEntityException) {
            callback.onFailure(e.getCause());
        } else {
            callback.onFailure(e);
        }
    }

    public static interface Action<T> {
        public T run(ReviewDb var1) throws OrmException, Failure, NoSuchProjectException, NoSuchGroupException, InvalidQueryException;
    }

    public static class Failure
    extends Exception {
        private static final long serialVersionUID = 1L;

        public Failure(Throwable why) {
            super(why);
        }
    }
}

