/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.account;

import com.google.common.base.Strings;
import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.common.data.AccountSecurity;
import com.google.gerrit.common.data.ContributorAgreement;
import com.google.gerrit.common.errors.ContactInformationStoreException;
import com.google.gerrit.common.errors.NoSuchEntityException;
import com.google.gerrit.common.errors.PermissionDeniedException;
import com.google.gerrit.httpd.rpc.BaseServiceImplementation;
import com.google.gerrit.httpd.rpc.Handler;
import com.google.gerrit.httpd.rpc.account.DeleteExternalIds;
import com.google.gerrit.httpd.rpc.account.ExternalIdDetailFactory;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.client.AccountGroupMemberAudit;
import com.google.gerrit.reviewdb.client.ContactInformation;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountByEmailCache;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.ChangeUserName;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.contact.ContactStore;
import com.google.gerrit.server.mail.EmailTokenVerifier;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtjsonrpc.common.AsyncCallback;
import com.google.gwtjsonrpc.common.VoidResult;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class AccountSecurityImpl
extends BaseServiceImplementation
implements AccountSecurity {
    private final ContactStore contactStore;
    private final Realm realm;
    private final ProjectCache projectCache;
    private final Provider<IdentifiedUser> user;
    private final EmailTokenVerifier emailTokenVerifier;
    private final AccountByEmailCache byEmailCache;
    private final AccountCache accountCache;
    private final AccountManager accountManager;
    private final boolean useContactInfo;
    private final ChangeUserName.CurrentUser changeUserNameFactory;
    private final DeleteExternalIds.Factory deleteExternalIdsFactory;
    private final ExternalIdDetailFactory.Factory externalIdDetailFactory;
    private final ChangeHooks hooks;
    private final GroupCache groupCache;

    @Inject
    AccountSecurityImpl(Provider<ReviewDb> schema, Provider<CurrentUser> currentUser, ContactStore cs, Realm r, Provider<IdentifiedUser> u, EmailTokenVerifier etv, ProjectCache pc, AccountByEmailCache abec, AccountCache uac, AccountManager am, ChangeUserName.CurrentUser changeUserNameFactory, DeleteExternalIds.Factory deleteExternalIdsFactory, ExternalIdDetailFactory.Factory externalIdDetailFactory, ChangeHooks hooks, GroupCache groupCache) {
        super(schema, currentUser);
        this.contactStore = cs;
        this.realm = r;
        this.user = u;
        this.emailTokenVerifier = etv;
        this.projectCache = pc;
        this.byEmailCache = abec;
        this.accountCache = uac;
        this.accountManager = am;
        this.useContactInfo = this.contactStore != null && this.contactStore.isEnabled();
        this.changeUserNameFactory = changeUserNameFactory;
        this.deleteExternalIdsFactory = deleteExternalIdsFactory;
        this.externalIdDetailFactory = externalIdDetailFactory;
        this.hooks = hooks;
        this.groupCache = groupCache;
    }

    @Override
    public void changeUserName(String newName, AsyncCallback<VoidResult> callback) {
        if (this.realm.allowsEdit(Account.FieldName.USER_NAME)) {
            Handler.wrap(this.changeUserNameFactory.create(newName)).to(callback);
        } else {
            callback.onFailure(new PermissionDeniedException("Not allowed to change username"));
        }
    }

    @Override
    public void myExternalIds(AsyncCallback<List<AccountExternalId>> callback) {
        this.externalIdDetailFactory.create().to(callback);
    }

    @Override
    public void deleteExternalIds(Set<AccountExternalId.Key> keys, AsyncCallback<Set<AccountExternalId.Key>> callback) {
        this.deleteExternalIdsFactory.create(keys).to(callback);
    }

    @Override
    public void updateContact(final String name, final String emailAddr, final ContactInformation info, AsyncCallback<Account> callback) {
        this.run(callback, new BaseServiceImplementation.Action<Account>(){

            @Override
            public Account run(ReviewDb db) throws OrmException, BaseServiceImplementation.Failure {
                IdentifiedUser self = (IdentifiedUser)AccountSecurityImpl.this.user.get();
                Account me = db.accounts().get(self.getAccountId());
                String oldEmail = me.getPreferredEmail();
                if (AccountSecurityImpl.this.realm.allowsEdit(Account.FieldName.FULL_NAME)) {
                    me.setFullName(Strings.emptyToNull(name));
                }
                if (!Strings.isNullOrEmpty(emailAddr) && !self.getEmailAddresses().contains(emailAddr)) {
                    throw new BaseServiceImplementation.Failure(new PermissionDeniedException("Email address must be verified"));
                }
                me.setPreferredEmail(Strings.emptyToNull(emailAddr));
                if (AccountSecurityImpl.this.useContactInfo) {
                    if (ContactInformation.hasAddress(info) || me.isContactFiled() && ContactInformation.hasData(info)) {
                        me.setContactFiled(TimeUtil.nowTs());
                    }
                    if (ContactInformation.hasData(info)) {
                        try {
                            AccountSecurityImpl.this.contactStore.store(me, info);
                        }
                        catch (ContactInformationStoreException e) {
                            throw new BaseServiceImplementation.Failure(e);
                        }
                    }
                }
                db.accounts().update(Collections.singleton(me));
                if (!AccountSecurityImpl.eq(oldEmail, me.getPreferredEmail())) {
                    AccountSecurityImpl.this.byEmailCache.evict(oldEmail);
                    AccountSecurityImpl.this.byEmailCache.evict(me.getPreferredEmail());
                }
                AccountSecurityImpl.this.accountCache.evict(me.getId());
                return me;
            }
        });
    }

    private static boolean eq(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && a.equals(b);
    }

    @Override
    public void enterAgreement(final String agreementName, AsyncCallback<VoidResult> callback) {
        this.run(callback, new BaseServiceImplementation.Action<VoidResult>(){

            @Override
            public VoidResult run(ReviewDb db) throws OrmException, BaseServiceImplementation.Failure {
                ContributorAgreement ca = AccountSecurityImpl.this.projectCache.getAllProjects().getConfig().getContributorAgreement(agreementName);
                if (ca == null) {
                    throw new BaseServiceImplementation.Failure(new NoSuchEntityException());
                }
                if (ca.getAutoVerify() == null) {
                    throw new BaseServiceImplementation.Failure(new IllegalStateException("cannot enter a non-autoVerify agreement"));
                }
                if (ca.getAutoVerify().getUUID() == null) {
                    throw new BaseServiceImplementation.Failure(new NoSuchEntityException());
                }
                AccountGroup group = AccountSecurityImpl.this.groupCache.get(ca.getAutoVerify().getUUID());
                if (group == null) {
                    throw new BaseServiceImplementation.Failure(new NoSuchEntityException());
                }
                Account account = ((IdentifiedUser)AccountSecurityImpl.this.user.get()).getAccount();
                AccountSecurityImpl.this.hooks.doClaSignupHook(account, ca);
                AccountGroupMember.Key key = new AccountGroupMember.Key(account.getId(), group.getId());
                AccountGroupMember m = db.accountGroupMembers().get(key);
                if (m == null) {
                    m = new AccountGroupMember(key);
                    db.accountGroupMembersAudit().insert(Collections.singleton(new AccountGroupMemberAudit(m, account.getId(), TimeUtil.nowTs())));
                    db.accountGroupMembers().insert(Collections.singleton(m));
                    AccountSecurityImpl.this.accountCache.evict(m.getAccountId());
                }
                return VoidResult.INSTANCE;
            }
        });
    }

    @Override
    public void validateEmail(String tokenString, AsyncCallback<VoidResult> callback) {
        try {
            EmailTokenVerifier.ParsedToken token = this.emailTokenVerifier.decode(tokenString);
            Account.Id currentUser = this.user.get().getAccountId();
            if (!currentUser.equals(token.getAccountId())) {
                throw new EmailTokenVerifier.InvalidTokenException();
            }
            this.accountManager.link(currentUser, token.toAuthRequest());
            callback.onSuccess(VoidResult.INSTANCE);
        }
        catch (EmailTokenVerifier.InvalidTokenException e) {
            callback.onFailure(e);
        }
        catch (AccountException e) {
            callback.onFailure(e);
        }
        catch (OrmException e) {
            callback.onFailure(e);
        }
    }
}

