/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.account;

import com.google.gerrit.httpd.rpc.Handler;
import com.google.gerrit.httpd.rpc.account.ExternalIdDetailFactory;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountByEmailCache;
import com.google.gerrit.server.account.AccountCache;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DeleteExternalIds
extends Handler<Set<AccountExternalId.Key>> {
    private final ReviewDb db;
    private final IdentifiedUser user;
    private final ExternalIdDetailFactory detailFactory;
    private final AccountByEmailCache byEmailCache;
    private final AccountCache accountCache;
    private final Set<AccountExternalId.Key> keys;

    @Inject
    DeleteExternalIds(ReviewDb db, IdentifiedUser user, ExternalIdDetailFactory detailFactory, AccountByEmailCache byEmailCache, AccountCache accountCache, @Assisted Set<AccountExternalId.Key> keys) {
        this.db = db;
        this.user = user;
        this.detailFactory = detailFactory;
        this.byEmailCache = byEmailCache;
        this.accountCache = accountCache;
        this.keys = keys;
    }

    @Override
    public Set<AccountExternalId.Key> call() throws OrmException {
        Map<AccountExternalId.Key, AccountExternalId> have = this.have();
        ArrayList<AccountExternalId> toDelete = new ArrayList<AccountExternalId>();
        for (AccountExternalId.Key k : this.keys) {
            AccountExternalId id = have.get(k);
            if (id == null || !id.canDelete()) continue;
            toDelete.add(id);
        }
        if (!toDelete.isEmpty()) {
            this.db.accountExternalIds().delete(toDelete);
            this.accountCache.evict(this.user.getAccountId());
            for (AccountExternalId e : toDelete) {
                this.byEmailCache.evict(e.getEmailAddress());
            }
        }
        return this.toKeySet(toDelete);
    }

    private Map<AccountExternalId.Key, AccountExternalId> have() throws OrmException {
        HashMap<AccountExternalId.Key, AccountExternalId> r = new HashMap<AccountExternalId.Key, AccountExternalId>();
        Iterator i$ = this.detailFactory.call().iterator();
        while (i$.hasNext()) {
            AccountExternalId i = (AccountExternalId)i$.next();
            r.put(i.getKey(), i);
        }
        return r;
    }

    private Set<AccountExternalId.Key> toKeySet(List<AccountExternalId> toDelete) {
        HashSet<AccountExternalId.Key> r = new HashSet<AccountExternalId.Key>();
        for (AccountExternalId i : toDelete) {
            r.add(i.getKey());
        }
        return r;
    }

    static interface Factory {
        public DeleteExternalIds create(Set<AccountExternalId.Key> var1);
    }
}

