/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.project;

import com.google.common.base.Objects;
import com.google.gerrit.common.ProjectAccessUtil;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.errors.InvalidNameException;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.common.errors.UpdateParentFailedException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.httpd.rpc.Handler;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.gerrit.server.config.AllProjectsNameProvider;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.project.SetParent;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;

public abstract class ProjectAccessHandler<T>
extends Handler<T> {
    private final ProjectControl.Factory projectControlFactory;
    protected final GroupBackend groupBackend;
    private final MetaDataUpdate.User metaDataUpdateFactory;
    private final AllProjectsNameProvider allProjects;
    private final Provider<SetParent> setParent;
    protected final Project.NameKey projectName;
    protected final ObjectId base;
    private List<AccessSection> sectionList;
    private final Project.NameKey parentProjectName;
    protected String message;
    private boolean checkIfOwner;

    protected ProjectAccessHandler(ProjectControl.Factory projectControlFactory, GroupBackend groupBackend, MetaDataUpdate.User metaDataUpdateFactory, AllProjectsNameProvider allProjects, Provider<SetParent> setParent, Project.NameKey projectName, ObjectId base, List<AccessSection> sectionList, Project.NameKey parentProjectName, String message, boolean checkIfOwner) {
        this.projectControlFactory = projectControlFactory;
        this.groupBackend = groupBackend;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.allProjects = allProjects;
        this.setParent = setParent;
        this.projectName = projectName;
        this.base = base;
        this.sectionList = sectionList;
        this.parentProjectName = parentProjectName;
        this.message = message;
        this.checkIfOwner = checkIfOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T call() throws NoSuchProjectException, IOException, ConfigInvalidException, InvalidNameException, NoSuchGroupException, OrmException, UpdateParentFailedException {
        MetaDataUpdate md;
        ProjectControl projectControl = this.projectControlFactory.controlFor(this.projectName);
        try {
            md = this.metaDataUpdateFactory.create(this.projectName);
        }
        catch (RepositoryNotFoundException notFound) {
            throw new NoSuchProjectException(this.projectName);
        }
        try {
            ProjectConfig config = ProjectConfig.read(md, this.base);
            Set<String> toDelete = ProjectAccessHandler.scanSectionNames(config);
            for (AccessSection section : ProjectAccessUtil.mergeSections(this.sectionList)) {
                String name = section.getName();
                if ("GLOBAL_CAPABILITIES".equals(name)) {
                    if (this.checkIfOwner && !projectControl.isOwner()) continue;
                    this.replace(config, toDelete, section);
                    continue;
                }
                if (!AccessSection.isValid(name) || this.checkIfOwner && !projectControl.controlForRef(name).isOwner()) continue;
                RefControl.validateRefPattern(name);
                this.replace(config, toDelete, section);
            }
            for (String name : toDelete) {
                if ("GLOBAL_CAPABILITIES".equals(name)) {
                    if (this.checkIfOwner && !projectControl.isOwner()) continue;
                    config.remove(config.getAccessSection(name));
                    continue;
                }
                if (this.checkIfOwner && !projectControl.controlForRef(name).isOwner()) continue;
                config.remove(config.getAccessSection(name));
            }
            boolean parentProjectUpdate = false;
            if (!config.getProject().getNameKey().equals(this.allProjects.get()) && !config.getProject().getParent(this.allProjects.get()).equals(this.parentProjectName)) {
                parentProjectUpdate = true;
                try {
                    this.setParent.get().validateParentUpdate(projectControl, ((Project.NameKey)Objects.firstNonNull(this.parentProjectName, this.allProjects.get())).get(), this.checkIfOwner);
                }
                catch (AuthException e) {
                    throw new UpdateParentFailedException("You are not allowed to change the parent project since you are not an administrator. You may save the modifications for review so that an administrator can approve them.", e);
                }
                catch (ResourceConflictException e) {
                    throw new UpdateParentFailedException(e.getMessage(), e);
                }
                catch (UnprocessableEntityException e) {
                    throw new UpdateParentFailedException(e.getMessage(), e);
                }
                config.getProject().setParentName(this.parentProjectName);
            }
            if (this.message != null && !this.message.isEmpty()) {
                if (!this.message.endsWith("\n")) {
                    this.message = this.message + "\n";
                }
                md.setMessage(this.message);
            } else {
                md.setMessage("Modify access rules\n");
            }
            T t = this.updateProjectConfig(config, md, parentProjectUpdate);
            return t;
        }
        finally {
            md.close();
        }
    }

    protected abstract T updateProjectConfig(ProjectConfig var1, MetaDataUpdate var2, boolean var3) throws IOException, NoSuchProjectException, ConfigInvalidException, OrmException;

    private void replace(ProjectConfig config, Set<String> toDelete, AccessSection section) throws NoSuchGroupException {
        for (Permission permission : section.getPermissions()) {
            for (PermissionRule rule : permission.getRules()) {
                this.lookupGroup(rule);
            }
        }
        config.replace(section);
        toDelete.remove(section.getName());
    }

    private static Set<String> scanSectionNames(ProjectConfig config) {
        HashSet<String> names = new HashSet<String>();
        for (AccessSection section : config.getAccessSections()) {
            names.add(section.getName());
        }
        return names;
    }

    private void lookupGroup(PermissionRule rule) throws NoSuchGroupException {
        GroupReference ref = rule.getGroup();
        if (ref.getUUID() == null) {
            GroupReference group = GroupBackends.findBestSuggestion(this.groupBackend, ref.getName());
            if (group == null) {
                throw new NoSuchGroupException(ref.getName());
            }
            ref.setUUID(group.getUUID());
        }
    }
}

