/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.lifecycle;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Providers;
import java.util.List;
import org.slf4j.LoggerFactory;

public class LifecycleManager {
    private final List<Provider<LifecycleListener>> listeners = LifecycleManager.newList();
    private final List<RegistrationHandle> handles = LifecycleManager.newList();
    private int startedIndex = -1;

    public void add(RegistrationHandle handle) {
        this.handles.add(handle);
    }

    public void add(LifecycleListener listener) {
        this.listeners.add(Providers.of(listener));
    }

    public void add(Provider<LifecycleListener> listener) {
        this.listeners.add(listener);
    }

    public void add(Injector injector) {
        Preconditions.checkState(this.startedIndex < 0, "Already started");
        for (Binding<LifecycleListener> binding : LifecycleManager.get(injector)) {
            this.add(binding.getProvider());
        }
    }

    public void add(Injector ... injectors) {
        for (Injector i : injectors) {
            this.add(i);
        }
    }

    public void start() {
        int i = this.startedIndex + 1;
        while (i < this.listeners.size()) {
            LifecycleListener listener = this.listeners.get(i).get();
            this.startedIndex = i++;
            listener.start();
        }
    }

    public void stop() {
        int i;
        for (i = this.handles.size() - 1; 0 <= i; --i) {
            this.handles.get(i).remove();
        }
        this.handles.clear();
        for (i = this.startedIndex; 0 <= i; --i) {
            LifecycleListener obj = this.listeners.get(i).get();
            try {
                obj.stop();
            }
            catch (Throwable err) {
                LoggerFactory.getLogger(obj.getClass()).warn("Failed to stop", err);
            }
            this.startedIndex = i - 1;
        }
    }

    private static List<Binding<LifecycleListener>> get(Injector i) {
        return i.findBindingsByType(new TypeLiteral<LifecycleListener>(){});
    }

    private static <T> List<T> newList() {
        return Lists.newArrayListWithCapacity(4);
    }
}

