/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.pgm.util;

import com.google.gerrit.pgm.util.Die;
import java.io.Console;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jgit.util.StringUtils;

public abstract class ConsoleUI {
    public static ConsoleUI getInstance() {
        return ConsoleUI.getInstance(false);
    }

    public static ConsoleUI getInstance(boolean batchMode) {
        Console console = batchMode ? null : System.console();
        return console != null ? new Interactive(console) : new Batch();
    }

    protected static Die abort() {
        return new Die("aborted by user");
    }

    protected static <T extends Enum<?>> T[] all(T value) {
        try {
            return (Enum[])value.getClass().getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot obtain enumeration values", e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Cannot obtain enumeration values", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot obtain enumeration values", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot obtain enumeration values", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot obtain enumeration values", e);
        }
    }

    public abstract boolean isBatch();

    public abstract void header(String var1, Object ... var2);

    public abstract void message(String var1, Object ... var2);

    public abstract boolean yesno(Boolean var1, String var2, Object ... var3);

    public abstract void waitForUser();

    public abstract String readString(String var1, String var2, Object ... var3);

    public abstract String readString(String var1, Set<String> var2, String var3, Object ... var4);

    public int readInt(int def, String fmt, Object ... args) {
        while (true) {
            String p = this.readString(String.valueOf(def), fmt, args);
            try {
                return Integer.parseInt(p.trim(), 10);
            }
            catch (NumberFormatException e) {
                System.err.println("error: Invalid integer format: " + p.trim());
                continue;
            }
            break;
        }
    }

    public abstract String password(String var1, Object ... var2);

    public abstract <T extends Enum<?>> T readEnum(T var1, String var2, Object ... var3);

    private static class Batch
    extends ConsoleUI {
        private Batch() {
        }

        @Override
        public boolean isBatch() {
            return true;
        }

        @Override
        public boolean yesno(Boolean def, String fmt, Object ... args) {
            return def != null ? def : true;
        }

        @Override
        public String readString(String def, String fmt, Object ... args) {
            return def;
        }

        @Override
        public String readString(String def, Set<String> allowedValues, String fmt, Object ... args) {
            return def;
        }

        @Override
        public void waitForUser() {
        }

        @Override
        public String password(String fmt, Object ... args) {
            return null;
        }

        @Override
        public <T extends Enum<?>> T readEnum(T def, String fmt, Object ... args) {
            return def;
        }

        @Override
        public void header(String fmt, Object ... args) {
        }

        @Override
        public void message(String fmt, Object ... args) {
        }
    }

    private static class Interactive
    extends ConsoleUI {
        private final Console console;

        Interactive(Console console) {
            this.console = console;
        }

        @Override
        public boolean isBatch() {
            return false;
        }

        @Override
        public boolean yesno(Boolean def, String fmt, Object ... args) {
            String yn;
            String prompt = String.format(fmt, args);
            do {
                String y = "y";
                String n = "n";
                if (def != null) {
                    if (def.booleanValue()) {
                        y = "Y";
                    } else {
                        n = "N";
                    }
                }
                if ((yn = this.console.readLine("%-30s [%s/%s]? ", prompt, y, n)) == null) {
                    throw Interactive.abort();
                }
                yn = yn.trim();
                if (def != null && yn.isEmpty()) {
                    return def;
                }
                if (!yn.equalsIgnoreCase("y") && !yn.equalsIgnoreCase("yes")) continue;
                return true;
            } while (!yn.equalsIgnoreCase("n") && !yn.equalsIgnoreCase("no"));
            return false;
        }

        @Override
        public void waitForUser() {
            if (this.console.readLine("Press enter to continue ", new Object[0]) == null) {
                throw Interactive.abort();
            }
        }

        @Override
        public String readString(String def, String fmt, Object ... args) {
            String prompt = String.format(fmt, args);
            String r = def != null ? this.console.readLine("%-30s [%s]: ", prompt, def) : this.console.readLine("%-30s : ", prompt);
            if (r == null) {
                throw Interactive.abort();
            }
            if ((r = r.trim()).isEmpty()) {
                return def;
            }
            return r;
        }

        @Override
        public String readString(String def, Set<String> allowedValues, String fmt, Object ... args) {
            String r;
            block0: while (!allowedValues.contains((r = this.readString(def, fmt, args)).toLowerCase())) {
                if (!"?".equals(r)) {
                    this.console.printf("error: '%s' is not a valid choice\n", r);
                }
                this.console.printf("       Supported options are:\n", new Object[0]);
                Iterator<String> i$ = allowedValues.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    String v = i$.next();
                    this.console.printf("         %s\n", v.toLowerCase());
                }
                break;
            }
            return r.toLowerCase();
        }

        @Override
        public String password(String fmt, Object ... args) {
            String s1;
            String prompt = String.format(fmt, args);
            while (true) {
                char[] a1;
                if ((a1 = this.console.readPassword("%-30s : ", prompt)) == null) {
                    throw Interactive.abort();
                }
                char[] a2 = this.console.readPassword("%30s : ", "confirm password");
                if (a2 == null) {
                    throw Interactive.abort();
                }
                s1 = new String(a1);
                String s2 = new String(a2);
                if (s1.equals(s2)) break;
                this.console.printf("error: Passwords did not match; try again\n", new Object[0]);
            }
            return !s1.isEmpty() ? s1 : null;
        }

        @Override
        public <T extends Enum<?>> T readEnum(T def, String fmt, Object ... args) {
            String prompt = String.format(fmt, args);
            Enum[] options = Interactive.all(def);
            block0: while (true) {
                String r;
                if ((r = this.console.readLine("%-30s [%s/?]: ", prompt, def.toString())) == null) {
                    throw Interactive.abort();
                }
                if ((r = r.trim()).isEmpty()) {
                    return def;
                }
                for (Enum e : options) {
                    if (!StringUtils.equalsIgnoreCase(e.toString(), r)) continue;
                    return (T)e;
                }
                if (!"?".equals(r)) {
                    this.console.printf("error: '%s' is not a valid choice\n", r);
                }
                this.console.printf("       Supported options are:\n", new Object[0]);
                Enum[] arr$ = options;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    Enum e;
                    if (i$ >= len$) continue block0;
                    e = arr$[i$];
                    this.console.printf("         %s\n", e.toString().toLowerCase());
                    ++i$;
                }
                break;
            }
        }

        @Override
        public void header(String fmt, Object ... args) {
            fmt = fmt.replaceAll("\n", "\n*** ");
            this.console.printf("\n*** " + fmt + "\n*** \n\n", args);
        }

        @Override
        public void message(String fmt, Object ... args) {
            this.console.printf(fmt, args);
        }
    }
}

