/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.AccountGeneralPreferences;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.IntKey;
import com.google.gwtorm.client.Key;
import java.sql.Timestamp;

public final class Account {
    public static final String USER_NAME_PATTERN_FIRST = "[a-zA-Z0-9]";
    public static final String USER_NAME_PATTERN_REST = "[a-zA-Z0-9._-]";
    public static final String USER_NAME_PATTERN_LAST = "[a-zA-Z0-9]";
    public static final String USER_NAME_PATTERN = "^([a-zA-Z0-9][a-zA-Z0-9._-]*[a-zA-Z0-9]|[a-zA-Z0-9])$";
    @Column(id=1)
    protected Id accountId;
    @Column(id=2)
    protected Timestamp registeredOn;
    @Column(id=3, notNull=false)
    protected String fullName;
    @Column(id=4, notNull=false)
    protected String preferredEmail;
    @Column(id=5, notNull=false)
    protected Timestamp contactFiledOn;
    @Column(id=6, name="--NONE--")
    protected AccountGeneralPreferences generalPreferences;
    @Column(id=7)
    protected boolean inactive;
    protected String userName;

    protected Account() {
    }

    public Account(Id newId, Timestamp registeredOn) {
        this.accountId = newId;
        this.registeredOn = registeredOn;
        this.generalPreferences = new AccountGeneralPreferences();
        this.generalPreferences.resetToDefaults();
    }

    public Id getId() {
        return this.accountId;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String name) {
        this.fullName = name != null && !name.trim().isEmpty() ? name.trim() : null;
    }

    public String getPreferredEmail() {
        return this.preferredEmail;
    }

    public void setPreferredEmail(String addr) {
        this.preferredEmail = addr;
    }

    public Timestamp getRegisteredOn() {
        return this.registeredOn;
    }

    public AccountGeneralPreferences getGeneralPreferences() {
        return this.generalPreferences;
    }

    public void setGeneralPreferences(AccountGeneralPreferences p) {
        this.generalPreferences = p;
    }

    public boolean isContactFiled() {
        return this.contactFiledOn != null;
    }

    public Timestamp getContactFiledOn() {
        return this.contactFiledOn;
    }

    public void setContactFiled(Timestamp ts) {
        this.contactFiledOn = ts;
    }

    public boolean isActive() {
        return !this.inactive;
    }

    public void setActive(boolean active) {
        this.inactive = !active;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        return o instanceof Account && ((Account)o).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().get();
    }

    public static class Id
    extends IntKey<Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected int id;

        protected Id() {
        }

        public Id(int id) {
            this.id = id;
        }

        @Override
        public int get() {
            return this.id;
        }

        @Override
        protected void set(int newValue) {
            this.id = newValue;
        }

        public static Id parse(String str) {
            Id r = new Id();
            r.fromString(str);
            return r;
        }
    }

    public static enum FieldName {
        FULL_NAME,
        USER_NAME,
        REGISTER_NEW_EMAIL;

    }
}

