/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.CompoundKey;
import com.google.gwtorm.client.StringKey;

public final class AccountProjectWatch {
    public static final String FILTER_ALL = "*";
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2)
    protected boolean notifyNewChanges;
    @Column(id=3)
    protected boolean notifyAllComments;
    @Column(id=4)
    protected boolean notifySubmittedChanges;
    @Column(id=5)
    protected boolean notifyNewPatchSets;
    @Column(id=6)
    protected boolean notifyAbandonedChanges;

    protected AccountProjectWatch() {
    }

    public AccountProjectWatch(Key k) {
        this.key = k;
    }

    public Key getKey() {
        return this.key;
    }

    public Account.Id getAccountId() {
        return this.key.accountId;
    }

    public Project.NameKey getProjectNameKey() {
        return this.key.projectName;
    }

    public String getFilter() {
        return FILTER_ALL.equals(this.key.filter.get()) ? null : this.key.filter.get();
    }

    public boolean isNotify(NotifyType type) {
        switch (type) {
            case NEW_CHANGES: {
                return this.notifyNewChanges;
            }
            case NEW_PATCHSETS: {
                return this.notifyNewPatchSets;
            }
            case ALL_COMMENTS: {
                return this.notifyAllComments;
            }
            case SUBMITTED_CHANGES: {
                return this.notifySubmittedChanges;
            }
            case ABANDONED_CHANGES: {
                return this.notifyAbandonedChanges;
            }
        }
        return false;
    }

    public void setNotify(NotifyType type, boolean v) {
        switch (type) {
            case NEW_CHANGES: {
                this.notifyNewChanges = v;
                break;
            }
            case NEW_PATCHSETS: {
                this.notifyNewPatchSets = v;
                break;
            }
            case ALL_COMMENTS: {
                this.notifyAllComments = v;
                break;
            }
            case SUBMITTED_CHANGES: {
                this.notifySubmittedChanges = v;
                break;
            }
            case ABANDONED_CHANGES: {
                this.notifyAbandonedChanges = v;
                break;
            }
            case ALL: {
                this.notifyNewChanges = v;
                this.notifyNewPatchSets = v;
                this.notifyAllComments = v;
                this.notifySubmittedChanges = v;
                this.notifyAbandonedChanges = v;
            }
        }
    }

    public static class Filter
    extends StringKey<com.google.gwtorm.client.Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected String filter;

        protected Filter() {
        }

        public Filter(String f) {
            this.filter = f != null && !f.isEmpty() ? f : AccountProjectWatch.FILTER_ALL;
        }

        @Override
        public String get() {
            return this.filter;
        }

        @Override
        protected void set(String newValue) {
            this.filter = newValue;
        }
    }

    public static class Key
    extends CompoundKey<Account.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected Account.Id accountId;
        @Column(id=2)
        protected Project.NameKey projectName;
        @Column(id=3)
        protected Filter filter;

        protected Key() {
            this.accountId = new Account.Id();
            this.projectName = new Project.NameKey();
            this.filter = new Filter();
        }

        public Key(Account.Id a, Project.NameKey g, String f) {
            this.accountId = a;
            this.projectName = g;
            this.filter = new Filter(f);
        }

        @Override
        public Account.Id getParentKey() {
            return this.accountId;
        }

        public Project.NameKey getProjectName() {
            return this.projectName;
        }

        public Filter getFilter() {
            return this.filter;
        }

        @Override
        public com.google.gwtorm.client.Key<?>[] members() {
            return new com.google.gwtorm.client.Key[]{this.projectName, this.filter};
        }
    }

    public static enum NotifyType {
        NEW_CHANGES,
        NEW_PATCHSETS,
        ALL_COMMENTS,
        SUBMITTED_CHANGES,
        ABANDONED_CHANGES,
        ALL;

    }
}

