/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.CommentRange;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.StringKey;
import java.sql.Timestamp;

public final class PatchLineComment {
    public static final char STATUS_DRAFT = 'd';
    public static final char STATUS_PUBLISHED = 'P';
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2)
    protected int lineNbr;
    @Column(id=3, name="author_id")
    protected Account.Id author;
    @Column(id=4)
    protected Timestamp writtenOn;
    @Column(id=5)
    protected char status;
    @Column(id=6)
    protected short side;
    @Column(id=7, notNull=false, length=0x7FFFFFFF)
    protected String message;
    @Column(id=8, length=40, notNull=false)
    protected String parentUuid;
    @Column(id=9, notNull=false)
    protected CommentRange range;

    protected PatchLineComment() {
    }

    public PatchLineComment(Key id, int line, Account.Id a, String parentUuid, Timestamp when) {
        this.key = id;
        this.lineNbr = line;
        this.author = a;
        this.setParentUuid(parentUuid);
        this.setStatus(Status.DRAFT);
        this.setWrittenOn(when);
    }

    public Key getKey() {
        return this.key;
    }

    public int getLine() {
        return this.lineNbr;
    }

    public void setLine(int line) {
        this.lineNbr = line;
    }

    public Account.Id getAuthor() {
        return this.author;
    }

    public Timestamp getWrittenOn() {
        return this.writtenOn;
    }

    public Status getStatus() {
        return Status.forCode(this.status);
    }

    public void setStatus(Status s) {
        this.status = s.getCode();
    }

    public short getSide() {
        return this.side;
    }

    public void setSide(short s) {
        this.side = s;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String s) {
        this.message = s;
    }

    public void setWrittenOn(Timestamp ts) {
        this.writtenOn = ts;
    }

    public String getParentUuid() {
        return this.parentUuid;
    }

    public void setParentUuid(String inReplyTo) {
        this.parentUuid = inReplyTo;
    }

    public void setRange(CommentRange r) {
        this.range = r;
    }

    public CommentRange getRange() {
        return this.range;
    }

    public static enum Status {
        DRAFT('d'),
        PUBLISHED('P');

        private final char code;

        private Status(char c) {
            this.code = c;
        }

        public char getCode() {
            return this.code;
        }

        public static Status forCode(char c) {
            for (Status s : Status.values()) {
                if (s.code != c) continue;
                return s;
            }
            return null;
        }
    }

    public static class Key
    extends StringKey<Patch.Key> {
        private static final long serialVersionUID = 1L;
        @Column(id=1, name="--NONE--")
        protected Patch.Key patchKey;
        @Column(id=2, length=40)
        protected String uuid;

        protected Key() {
            this.patchKey = new Patch.Key();
        }

        public Key(Patch.Key p, String uuid) {
            this.patchKey = p;
            this.uuid = uuid;
        }

        @Override
        public Patch.Key getParentKey() {
            return this.patchKey;
        }

        @Override
        public String get() {
            return this.uuid;
        }

        @Override
        protected void set(String newValue) {
            this.uuid = newValue;
        }
    }
}

