/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.IntKey;
import java.sql.Timestamp;

public final class PatchSet {
    @Column(id=1, name="--NONE--")
    protected Id id;
    @Column(id=2, notNull=false)
    protected RevId revision;
    @Column(id=3, name="uploader_account_id")
    protected Account.Id uploader;
    @Column(id=4)
    protected Timestamp createdOn;
    @Column(id=5)
    protected boolean draft;

    public static boolean isRef(String name) {
        if (name == null || !name.startsWith("refs/changes/")) {
            return false;
        }
        boolean accepted = false;
        int numsFound = 0;
        for (int i = name.length() - 1; i >= "refs/changes/".length() - 1; --i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9') {
                accepted = c != '0';
                continue;
            }
            if (c == '/') {
                if (!accepted) continue;
                if (++numsFound == 2) {
                    return true;
                }
                accepted = false;
                continue;
            }
            return false;
        }
        return false;
    }

    protected PatchSet() {
    }

    public PatchSet(Id k) {
        this.id = k;
    }

    public Id getId() {
        return this.id;
    }

    public int getPatchSetId() {
        return this.id.get();
    }

    public RevId getRevision() {
        return this.revision;
    }

    public void setRevision(RevId i) {
        this.revision = i;
    }

    public Account.Id getUploader() {
        return this.uploader;
    }

    public void setUploader(Account.Id who) {
        this.uploader = who;
    }

    public Timestamp getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Timestamp ts) {
        this.createdOn = ts;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void setDraft(boolean draftStatus) {
        this.draft = draftStatus;
    }

    public String getRefName() {
        return this.id.toRefName();
    }

    public String toString() {
        return "[PatchSet " + this.getId().toString() + "]";
    }

    public static class Id
    extends IntKey<Change.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected Change.Id changeId;
        @Column(id=2)
        protected int patchSetId;

        protected Id() {
            this.changeId = new Change.Id();
        }

        public Id(Change.Id change, int id) {
            this.changeId = change;
            this.patchSetId = id;
        }

        @Override
        public Change.Id getParentKey() {
            return this.changeId;
        }

        @Override
        public int get() {
            return this.patchSetId;
        }

        @Override
        protected void set(int newValue) {
            this.patchSetId = newValue;
        }

        public String toRefName() {
            StringBuilder r = new StringBuilder();
            r.append("refs/changes/");
            int change = this.changeId.get();
            int m = change % 100;
            if (m < 10) {
                r.append('0');
            }
            r.append(m);
            r.append('/');
            r.append(change);
            r.append('/');
            r.append(this.patchSetId);
            return r.toString();
        }

        public static Id parse(String str) {
            Id r = new Id();
            r.fromString(str);
            return r;
        }

        public static Id fromRef(String name) {
            if (!name.startsWith("refs/changes/")) {
                throw new IllegalArgumentException("Not a PatchSet.Id: " + name);
            }
            String[] parts = name.substring("refs/changes/".length()).split("/");
            int n = parts.length;
            if (n < 2) {
                throw new IllegalArgumentException("Not a PatchSet.Id: " + name);
            }
            int changeId = Integer.parseInt(parts[n - 2]);
            int patchSetId = Integer.parseInt(parts[n - 1]);
            return new Id(new Change.Id(changeId), patchSetId);
        }
    }
}

