/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.inject.servlet.RequestScoped;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class RequestCleanup
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RequestCleanup.class);
    private final List<Runnable> cleanup = new LinkedList<Runnable>();
    private boolean ran;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Runnable task) {
        List<Runnable> list = this.cleanup;
        synchronized (list) {
            if (this.ran) {
                throw new IllegalStateException("Request has already been cleaned up");
            }
            this.cleanup.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<Runnable> list = this.cleanup;
        synchronized (list) {
            this.ran = true;
            Iterator<Runnable> i = this.cleanup.iterator();
            while (i.hasNext()) {
                try {
                    i.next().run();
                }
                catch (Throwable err) {
                    log.error("Failed to execute per-request cleanup", err);
                }
                i.remove();
            }
        }
    }
}

