/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.access;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.data.RefConfigSection;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectJson;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.RefControl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.kohsuke.args4j.Option;

public class ListAccess
implements RestReadView<TopLevelResource> {
    @Option(name="--project", aliases={"-p"}, metaVar="PROJECT", usage="projects for which the access rights should be returned")
    private List<String> projects = Lists.newArrayList();
    private final Provider<CurrentUser> self;
    private final ProjectControl.GenericFactory projectControlFactory;
    private final ProjectCache projectCache;
    private final ProjectJson projectJson;
    private final MetaDataUpdate.Server metaDataUpdateFactory;
    private final GroupControl.Factory groupControlFactory;
    private final GroupBackend groupBackend;
    private final AllProjectsName allProjectsName;

    @Inject
    public ListAccess(Provider<CurrentUser> self, ProjectControl.GenericFactory projectControlFactory, ProjectCache projectCache, ProjectJson projectJson, MetaDataUpdate.Server metaDataUpdateFactory, GroupControl.Factory groupControlFactory, GroupBackend groupBackend, GroupJson groupJson, AllProjectsName allProjectsName) {
        this.self = self;
        this.projectControlFactory = projectControlFactory;
        this.projectCache = projectCache;
        this.projectJson = projectJson;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.groupControlFactory = groupControlFactory;
        this.groupBackend = groupBackend;
        this.allProjectsName = allProjectsName;
    }

    public Map<String, ProjectAccessInfo> apply(TopLevelResource resource) throws ResourceNotFoundException, ResourceConflictException, IOException {
        TreeMap<String, ProjectAccessInfo> access = Maps.newTreeMap();
        for (String p : this.projects) {
            ProjectConfig config;
            Project.NameKey projectName = new Project.NameKey(p);
            ProjectControl pc = this.open(projectName);
            try (MetaDataUpdate md = this.metaDataUpdateFactory.create(projectName);){
                config = ProjectConfig.read(md);
                if (config.updateGroupNames(this.groupBackend)) {
                    md.setMessage("Update group names\n");
                    config.commit(md);
                    this.projectCache.evict(config.getProject());
                    pc = this.open(projectName);
                } else if (config.getRevision() != null && !config.getRevision().equals(pc.getProjectState().getConfig().getRevision())) {
                    this.projectCache.evict(config.getProject());
                    pc = this.open(projectName);
                }
            }
            catch (RepositoryNotFoundException e) {
                throw new ResourceNotFoundException(p);
            }
            access.put(p, new ProjectAccessInfo(pc, config));
        }
        return access;
    }

    private ProjectControl open(Project.NameKey projectName) throws ResourceNotFoundException, IOException {
        try {
            return this.projectControlFactory.validateFor(projectName, 3, this.self.get());
        }
        catch (NoSuchProjectException e) {
            throw new ResourceNotFoundException(projectName.get());
        }
    }

    private static Boolean toBoolean(boolean value) {
        return value ? Boolean.valueOf(true) : null;
    }

    public class PermissionRuleInfo {
        public PermissionRule.Action action;
        public Boolean force;
        public Integer min;
        public Integer max;

        public PermissionRuleInfo(PermissionRule rule) {
            this.action = rule.getAction();
            this.force = ListAccess.toBoolean(rule.getForce());
            if (this.hasRange(rule)) {
                this.min = rule.getMin();
                this.max = rule.getMax();
            }
        }

        private boolean hasRange(PermissionRule rule) {
            return rule.getMin() != null && rule.getMin() != 0 || rule.getMax() != null && rule.getMax() != 0;
        }
    }

    public class PermissionInfo {
        public String label;
        public Boolean exclusive;
        public Map<String, PermissionRuleInfo> rules;

        public PermissionInfo(Permission permission) {
            this.label = permission.getLabel();
            this.exclusive = ListAccess.toBoolean(permission.getExclusiveGroup());
            this.rules = Maps.newHashMap();
            for (PermissionRule r : permission.getRules()) {
                this.rules.put(r.getGroup().getUUID().get(), new PermissionRuleInfo(r));
            }
        }
    }

    public class AccessSectionInfo {
        public Map<String, PermissionInfo> permissions = Maps.newHashMap();

        public AccessSectionInfo(AccessSection section) {
            for (Permission p : section.getPermissions()) {
                this.permissions.put(p.getName(), new PermissionInfo(p));
            }
        }
    }

    public class ProjectAccessInfo {
        public String revision;
        public ProjectJson.ProjectInfo inheritsFrom;
        public Map<String, AccessSectionInfo> local;
        public Boolean isOwner;
        public Set<String> ownerOf;
        public Boolean canUpload;
        public Boolean canAdd;
        public Boolean configVisible;

        public ProjectAccessInfo(ProjectControl pc, ProjectConfig config) {
            ProjectState parent;
            RefControl metaConfigControl = pc.controlForRef("refs/meta/config");
            this.local = Maps.newHashMap();
            this.ownerOf = Sets.newHashSet();
            HashMap<AccountGroup.UUID, Boolean> visibleGroups = new HashMap<AccountGroup.UUID, Boolean>();
            for (AccessSection section : config.getAccessSections()) {
                String name = section.getName();
                if ("GLOBAL_CAPABILITIES".equals(name)) {
                    if (pc.isOwner()) {
                        this.local.put(name, new AccessSectionInfo(section));
                        this.ownerOf.add(name);
                        continue;
                    }
                    if (!metaConfigControl.isVisible()) continue;
                    this.local.put(section.getName(), new AccessSectionInfo(section));
                    continue;
                }
                if (!RefConfigSection.isValid(name)) continue;
                RefControl rc = pc.controlForRef(name);
                if (rc.isOwner()) {
                    this.local.put(name, new AccessSectionInfo(section));
                    this.ownerOf.add(name);
                    continue;
                }
                if (metaConfigControl.isVisible()) {
                    this.local.put(name, new AccessSectionInfo(section));
                    continue;
                }
                if (!rc.isVisible()) continue;
                AccessSection dst = null;
                for (Permission srcPerm : section.getPermissions()) {
                    Permission dstPerm = null;
                    for (PermissionRule srcRule : srcPerm.getRules()) {
                        AccountGroup.UUID group = srcRule.getGroup().getUUID();
                        if (group == null) continue;
                        Boolean canSeeGroup = (Boolean)visibleGroups.get(group);
                        if (canSeeGroup == null) {
                            try {
                                canSeeGroup = ListAccess.this.groupControlFactory.controlFor(group).isVisible();
                            }
                            catch (NoSuchGroupException e) {
                                canSeeGroup = Boolean.FALSE;
                            }
                            visibleGroups.put(group, canSeeGroup);
                        }
                        if (!canSeeGroup.booleanValue()) continue;
                        if (dstPerm == null) {
                            if (dst == null) {
                                dst = new AccessSection(name);
                                this.local.put(name, new AccessSectionInfo(dst));
                            }
                            dstPerm = dst.getPermission(srcPerm.getName(), true);
                        }
                        dstPerm.add(srcRule);
                    }
                }
            }
            if (this.ownerOf.isEmpty() && pc.isOwnerAnyRef()) {
                this.ownerOf.add("refs/*");
            }
            if (config.getRevision() != null) {
                this.revision = config.getRevision().name();
            }
            if ((parent = (ProjectState)Iterables.getFirst(pc.getProjectState().parents(), null)) != null) {
                this.inheritsFrom = ListAccess.this.projectJson.format(parent.getProject());
            }
            if (pc.getProject().getNameKey().equals(ListAccess.this.allProjectsName) && pc.isOwner()) {
                this.ownerOf.add("GLOBAL_CAPABILITIES");
            }
            this.isOwner = ListAccess.toBoolean(pc.isOwner());
            this.canUpload = ListAccess.toBoolean(pc.isOwner() || metaConfigControl.isVisible() && metaConfigControl.canUpload());
            this.canAdd = ListAccess.toBoolean(pc.canAddRefs());
            this.configVisible = pc.isOwner() || metaConfigControl.isVisible();
        }
    }
}

