/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountVisibility;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.git.AccountsSection;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.project.ProjectCache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashSet;
import java.util.Set;

public class AccountControl {
    private final AccountsSection accountsSection;
    private final GroupControl.Factory groupControlFactory;
    private final CurrentUser currentUser;
    private final IdentifiedUser.GenericFactory userFactory;
    private final AccountVisibility accountVisibility;

    AccountControl(ProjectCache projectCache, GroupControl.Factory groupControlFactory, CurrentUser currentUser, IdentifiedUser.GenericFactory userFactory, AccountVisibility accountVisibility) {
        this.accountsSection = projectCache.getAllProjects().getConfig().getAccountsSection();
        this.groupControlFactory = groupControlFactory;
        this.currentUser = currentUser;
        this.userFactory = userFactory;
        this.accountVisibility = accountVisibility;
    }

    public boolean canSee(Account otherUser) {
        return this.canSee(otherUser.getId());
    }

    public boolean canSee(Account.Id otherUser) {
        if (this.currentUser.isIdentifiedUser() && ((IdentifiedUser)this.currentUser).getAccountId().equals(otherUser)) {
            return true;
        }
        if (this.currentUser.getCapabilities().canViewAllAccounts()) {
            return true;
        }
        switch (this.accountVisibility) {
            case ALL: {
                return true;
            }
            case SAME_GROUP: {
                Set<AccountGroup.UUID> usersGroups = this.groupsOf(otherUser);
                for (PermissionRule rule : this.accountsSection.getSameGroupVisibility()) {
                    if (!rule.isBlock() && !rule.isDeny()) continue;
                    usersGroups.remove(rule.getGroup().getUUID());
                }
                if (!this.currentUser.getEffectiveGroups().containsAnyOf(usersGroups)) break;
                return true;
            }
            case VISIBLE_GROUP: {
                Set<AccountGroup.UUID> usersGroups = this.groupsOf(otherUser);
                for (AccountGroup.UUID usersGroup : usersGroups) {
                    try {
                        if (!this.groupControlFactory.controlFor(usersGroup).isVisible()) continue;
                        return true;
                    }
                    catch (NoSuchGroupException e) {
                    }
                }
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("Bad AccountVisibility " + (Object)((Object)this.accountVisibility));
            }
        }
        return false;
    }

    private Set<AccountGroup.UUID> groupsOf(Account.Id account) {
        return new HashSet<AccountGroup.UUID>(Sets.filter(this.userFactory.create(account).getEffectiveGroups().getKnownGroups(), new Predicate<AccountGroup.UUID>(){

            @Override
            public boolean apply(AccountGroup.UUID in) {
                return !SystemGroupBackend.isSystemGroup(in);
            }
        }));
    }

    public static class Factory {
        private final ProjectCache projectCache;
        private final GroupControl.Factory groupControlFactory;
        private final Provider<CurrentUser> user;
        private final IdentifiedUser.GenericFactory userFactory;
        private final AccountVisibility accountVisibility;

        @Inject
        Factory(ProjectCache projectCache, GroupControl.Factory groupControlFactory, Provider<CurrentUser> user, IdentifiedUser.GenericFactory userFactory, AccountVisibility accountVisibility) {
            this.projectCache = projectCache;
            this.groupControlFactory = groupControlFactory;
            this.user = user;
            this.userFactory = userFactory;
            this.accountVisibility = accountVisibility;
        }

        public AccountControl get() {
            return new AccountControl(this.projectCache, this.groupControlFactory, this.user.get(), this.userFactory, this.accountVisibility);
        }
    }
}

