/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.client.AccountGroup;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class AccountState {
    private final Account account;
    private final Set<AccountGroup.UUID> internalGroups;
    private final Collection<AccountExternalId> externalIds;

    public AccountState(Account account, Set<AccountGroup.UUID> actualGroups, Collection<AccountExternalId> externalIds) {
        this.account = account;
        this.internalGroups = actualGroups;
        this.externalIds = externalIds;
        this.account.setUserName(AccountState.getUserName(externalIds));
    }

    public Account getAccount() {
        return this.account;
    }

    public String getUserName() {
        return this.account.getUserName();
    }

    public String getPassword(String username) {
        for (AccountExternalId id : this.getExternalIds()) {
            if (!id.isScheme("username:") || !username.equals(id.getSchemeRest())) continue;
            return id.getPassword();
        }
        return null;
    }

    public Set<String> getEmailAddresses() {
        HashSet<String> emails = new HashSet<String>();
        for (AccountExternalId e : this.externalIds) {
            if (e.getEmailAddress() == null || e.getEmailAddress().isEmpty()) continue;
            emails.add(e.getEmailAddress());
        }
        return emails;
    }

    public Collection<AccountExternalId> getExternalIds() {
        return this.externalIds;
    }

    public Set<AccountGroup.UUID> getInternalGroups() {
        return this.internalGroups;
    }

    private static String getUserName(Collection<AccountExternalId> ids) {
        for (AccountExternalId id : ids) {
            if (!id.isScheme("username:")) continue;
            return id.getSchemeRest();
        }
        return null;
    }
}

