/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.reviewdb.client.AccountExternalId;

public class AuthRequest {
    private String externalId;
    private String password;
    private String displayName;
    private String emailAddress;
    private String userName;
    private boolean skipAuthentication;

    public static AuthRequest forUser(String username) {
        AccountExternalId.Key i = new AccountExternalId.Key("gerrit:", username);
        AuthRequest r = new AuthRequest(i.get());
        r.setUserName(username);
        return r;
    }

    public static AuthRequest forEmail(String email) {
        AccountExternalId.Key i = new AccountExternalId.Key("mailto:", email);
        AuthRequest r = new AuthRequest(i.get());
        r.setEmailAddress(email);
        return r;
    }

    public AuthRequest(String externalId) {
        this.externalId = externalId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public boolean isScheme(String scheme) {
        return this.getExternalId().startsWith(scheme);
    }

    public String getLocalUser() {
        if (this.isScheme("gerrit:")) {
            return this.getExternalId().substring("gerrit:".length());
        }
        return null;
    }

    public void setLocalUser(String localUser) {
        if (this.isScheme("gerrit:")) {
            AccountExternalId.Key key = new AccountExternalId.Key("gerrit:", localUser);
            this.externalId = key.get();
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name != null && name.length() > 0 ? name : null;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String email) {
        this.emailAddress = email != null && email.length() > 0 ? email : null;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String user) {
        this.userName = user;
    }

    public boolean isSkipAuthentication() {
        return this.skipAuthentication;
    }

    public void setSkipAuthentication(boolean skip) {
        this.skipAuthentication = skip;
    }
}

