/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GlobalCapability;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.server.group.SystemGroupBackend;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CapabilityCollection {
    private final Map<String, List<PermissionRule>> permissions;
    public final List<PermissionRule> administrateServer;
    public final List<PermissionRule> emailReviewers;
    public final List<PermissionRule> priority;
    public final List<PermissionRule> queryLimit;
    private static final GroupReference anonymous = SystemGroupBackend.getGroup(SystemGroupBackend.ANONYMOUS_USERS);

    public CapabilityCollection(AccessSection section) {
        if (section == null) {
            section = new AccessSection("GLOBAL_CAPABILITIES");
        }
        HashMap<String, List<PermissionRule>> tmp = new HashMap<String, List<PermissionRule>>();
        for (Permission permission : section.getPermissions()) {
            for (PermissionRule rule : permission.getRules()) {
                if (!permission.getName().equals("emailReviewers") && rule.getAction() == PermissionRule.Action.DENY) continue;
                ArrayList<PermissionRule> r = (ArrayList<PermissionRule>)tmp.get(permission.getName());
                if (r == null) {
                    r = new ArrayList<PermissionRule>(2);
                    tmp.put(permission.getName(), r);
                }
                r.add(rule);
            }
        }
        CapabilityCollection.configureDefaults(tmp, section);
        HashMap res = new HashMap();
        for (Map.Entry e : tmp.entrySet()) {
            List rules = (List)e.getValue();
            if (rules.size() == 1) {
                res.put(e.getKey(), Collections.singletonList(rules.get(0)));
                continue;
            }
            res.put(e.getKey(), Collections.unmodifiableList(Arrays.asList(rules.toArray(new PermissionRule[rules.size()]))));
        }
        this.permissions = Collections.unmodifiableMap(res);
        this.administrateServer = this.getPermission("administrateServer");
        this.emailReviewers = this.getPermission("emailReviewers");
        this.priority = this.getPermission("priority");
        this.queryLimit = this.getPermission("queryLimit");
    }

    public List<PermissionRule> getPermission(String permissionName) {
        List<PermissionRule> r = this.permissions.get(permissionName);
        return r != null ? r : Collections.emptyList();
    }

    private static void configureDefaults(Map<String, List<PermissionRule>> out, AccessSection section) {
        CapabilityCollection.configureDefault(out, section, "queryLimit", anonymous);
    }

    private static void configureDefault(Map<String, List<PermissionRule>> out, AccessSection section, String capName, GroupReference group) {
        PermissionRange.WithDefaults range;
        if (CapabilityCollection.doesNotDeclare(section, capName) && (range = GlobalCapability.getRange(capName)) != null) {
            PermissionRule rule = new PermissionRule(group);
            rule.setRange(range.getDefaultMin(), range.getDefaultMax());
            out.put(capName, Collections.singletonList(rule));
        }
    }

    private static boolean doesNotDeclare(AccessSection section, String capName) {
        return section.getPermission(capName) == null;
    }
}

