/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.annotations.CapabilityScope;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.CapabilityControl;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilityUtils {
    private static final Logger log = LoggerFactory.getLogger(CapabilityUtils.class);

    public static void checkRequiresCapability(Provider<CurrentUser> userProvider, String pluginName, Class<?> clazz) throws AuthException {
        RequiresCapability rc = CapabilityUtils.getClassAnnotation(clazz, RequiresCapability.class);
        if (rc != null) {
            CurrentUser user = userProvider.get();
            CapabilityControl ctl = user.getCapabilities();
            if (ctl.canAdministrateServer()) {
                return;
            }
            String capability = rc.value();
            if (!(pluginName == null || "gerrit".equals(pluginName) || rc.scope() != CapabilityScope.PLUGIN && rc.scope() != CapabilityScope.CONTEXT)) {
                capability = String.format("%s-%s", pluginName, rc.value());
            } else if (rc.scope() == CapabilityScope.PLUGIN) {
                log.error(String.format("Class %s uses @%s(scope=%s), but is not within a plugin", clazz.getName(), RequiresCapability.class.getSimpleName(), CapabilityScope.PLUGIN.name()));
                throw new AuthException("cannot check capability");
            }
            if (!ctl.canPerform(capability)) {
                throw new AuthException(String.format("Capability %s is required to access this resource", capability));
            }
        }
    }

    private static <T extends Annotation> T getClassAnnotation(Class<?> clazz, Class<T> annotationClass) {
        while (clazz != null) {
            T t = clazz.getAnnotation(annotationClass);
            if (t != null) {
                return t;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }
}

