/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.Realm;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class DeleteEmail
implements RestModifyView<AccountResource.Email, Input> {
    private final Provider<CurrentUser> self;
    private final Realm realm;
    private final Provider<ReviewDb> dbProvider;
    private final AccountManager accountManager;

    @Inject
    DeleteEmail(Provider<CurrentUser> self, Realm realm, Provider<ReviewDb> dbProvider, AccountManager accountManager) {
        this.self = self;
        this.realm = realm;
        this.dbProvider = dbProvider;
        this.accountManager = accountManager;
    }

    public Response<?> apply(AccountResource.Email rsrc, Input input) throws AuthException, ResourceNotFoundException, ResourceConflictException, MethodNotAllowedException, OrmException {
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("not allowed to delete email address");
        }
        return this.apply(rsrc.getUser(), rsrc.getEmail());
    }

    public Response<?> apply(IdentifiedUser user, String email) throws ResourceNotFoundException, ResourceConflictException, MethodNotAllowedException, OrmException {
        if (!this.realm.allowsEdit(Account.FieldName.REGISTER_NEW_EMAIL)) {
            throw new MethodNotAllowedException("realm does not allow deleting emails");
        }
        AccountExternalId.Key key = new AccountExternalId.Key("mailto:", email);
        AccountExternalId extId = this.dbProvider.get().accountExternalIds().get(key);
        if (extId == null) {
            throw new ResourceNotFoundException(email);
        }
        try {
            this.accountManager.unlink(user.getAccountId(), AuthRequest.forEmail(email));
        }
        catch (AccountException e) {
            throw new ResourceConflictException(e.getMessage());
        }
        return Response.none();
    }

    public static class Input {
    }
}

