/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.CreateEmail;
import com.google.gerrit.server.account.GetEmails;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class Emails
implements ChildCollection<AccountResource, AccountResource.Email>,
AcceptsCreate<AccountResource> {
    private final DynamicMap<RestView<AccountResource.Email>> views;
    private final Provider<GetEmails> list;
    private final Provider<CurrentUser> self;
    private final CreateEmail.Factory createEmailFactory;

    @Inject
    Emails(DynamicMap<RestView<AccountResource.Email>> views, Provider<GetEmails> list, Provider<CurrentUser> self, CreateEmail.Factory createEmailFactory) {
        this.views = views;
        this.list = list;
        this.self = self;
        this.createEmailFactory = createEmailFactory;
    }

    @Override
    public RestView<AccountResource> list() {
        return this.list.get();
    }

    @Override
    public AccountResource.Email parse(AccountResource rsrc, IdString id) throws ResourceNotFoundException {
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new ResourceNotFoundException();
        }
        if ("preferred".equals(id.get())) {
            String email = rsrc.getUser().getAccount().getPreferredEmail();
            if (Strings.isNullOrEmpty(email)) {
                throw new ResourceNotFoundException();
            }
            return new AccountResource.Email(rsrc.getUser(), email);
        }
        if (rsrc.getUser().getEmailAddresses().contains(id.get())) {
            return new AccountResource.Email(rsrc.getUser(), id.get());
        }
        throw new ResourceNotFoundException();
    }

    @Override
    public DynamicMap<RestView<AccountResource.Email>> views() {
        return this.views;
    }

    public CreateEmail create(AccountResource parent, IdString email) {
        return this.createEmailFactory.create(email.get());
    }
}

