/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class GetEmails
implements RestReadView<AccountResource> {
    private final Provider<CurrentUser> self;

    @Inject
    public GetEmails(Provider<CurrentUser> self) {
        this.self = self;
    }

    public List<EmailInfo> apply(AccountResource rsrc) throws AuthException, OrmException {
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("not allowed to list email addresses");
        }
        ArrayList<EmailInfo> emails = Lists.newArrayList();
        for (String email : rsrc.getUser().getEmailAddresses()) {
            if (email == null) continue;
            EmailInfo e = new EmailInfo();
            e.email = email;
            e.preferred(rsrc.getUser().getAccount().getPreferredEmail());
            emails.add(e);
        }
        Collections.sort(emails, new Comparator<EmailInfo>(){

            @Override
            public int compare(EmailInfo a, EmailInfo b) {
                return a.email.compareTo(b.email);
            }
        });
        return emails;
    }

    public static class EmailInfo {
        public String email;
        public Boolean preferred;
        public Boolean pendingConfirmation;

        void preferred(String e) {
            this.preferred = e != null && e.equals(this.email) ? Boolean.valueOf(true) : null;
        }
    }
}

