/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.Lists;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.GroupJson;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;

public class GetGroups
implements RestReadView<AccountResource> {
    private final GroupControl.Factory groupControlFactory;
    private final GroupJson json;

    @Inject
    GetGroups(GroupControl.Factory groupControlFactory, GroupJson json) {
        this.groupControlFactory = groupControlFactory;
        this.json = json;
    }

    public List<GroupJson.GroupInfo> apply(AccountResource resource) throws OrmException {
        IdentifiedUser user = resource.getUser();
        Account.Id userId = user.getAccountId();
        ArrayList<GroupJson.GroupInfo> groups = Lists.newArrayList();
        for (AccountGroup.UUID uuid : user.getEffectiveGroups().getKnownGroups()) {
            GroupControl ctl;
            try {
                ctl = this.groupControlFactory.controlFor(uuid);
            }
            catch (NoSuchGroupException e) {
                continue;
            }
            if (!ctl.isVisible() || !ctl.canSeeMember(userId)) continue;
            groups.add(this.json.format(ctl.getGroup()));
        }
        return groups;
    }
}

