/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;

public class GetSshKeys
implements RestReadView<AccountResource> {
    private final Provider<CurrentUser> self;
    private final Provider<ReviewDb> dbProvider;

    @Inject
    GetSshKeys(Provider<CurrentUser> self, Provider<ReviewDb> dbProvider) {
        this.self = self;
        this.dbProvider = dbProvider;
    }

    public List<SshKeyInfo> apply(AccountResource rsrc) throws AuthException, OrmException {
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("not allowed to get SSH keys");
        }
        return this.apply(rsrc.getUser());
    }

    public List<SshKeyInfo> apply(IdentifiedUser user) throws OrmException {
        ArrayList<SshKeyInfo> sshKeys = Lists.newArrayList();
        for (AccountSshKey sshKey : this.dbProvider.get().accountSshKeys().byAccount(user.getAccountId()).toList()) {
            sshKeys.add(new SshKeyInfo(sshKey));
        }
        return sshKeys;
    }

    public static class SshKeyInfo {
        public int seq;
        public String sshPublicKey;
        public String encodedKey;
        public String algorithm;
        public String comment;
        public boolean valid;

        public SshKeyInfo(AccountSshKey sshKey) {
            this.seq = sshKey.getKey().get();
            this.sshPublicKey = sshKey.getSshPublicKey();
            this.encodedKey = sshKey.getEncodedKey();
            this.algorithm = sshKey.getAlgorithm();
            this.comment = Strings.emptyToNull(sshKey.getComment());
            this.valid = sshKey.isValid();
        }
    }
}

