/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.Maps;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupBackend;
import com.google.inject.Inject;
import java.util.Map;

public class GroupInfoCacheFactory {
    private final GroupBackend groupBackend;
    private final Map<AccountGroup.UUID, GroupDescription.Basic> out;

    @Inject
    GroupInfoCacheFactory(GroupBackend groupBackend) {
        this.groupBackend = groupBackend;
        this.out = Maps.newHashMap();
    }

    public void want(AccountGroup.UUID uuid) {
        if (uuid != null && !this.out.containsKey(uuid)) {
            this.out.put(uuid, this.groupBackend.get(uuid));
        }
    }

    public void want(Iterable<AccountGroup.UUID> uuids) {
        for (AccountGroup.UUID uuid : uuids) {
            this.want(uuid);
        }
    }

    public GroupDescription.Basic get(AccountGroup.UUID uuid) {
        this.want(uuid);
        return this.out.get(uuid);
    }

    public static interface Factory {
        public GroupInfoCacheFactory create();
    }
}

