/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;

@RequiresCapability(value="administrateServer")
public class PutActive
implements RestModifyView<AccountResource, Input> {
    private final Provider<ReviewDb> dbProvider;
    private final AccountCache byIdCache;

    @Inject
    PutActive(Provider<ReviewDb> dbProvider, AccountCache byIdCache) {
        this.dbProvider = dbProvider;
        this.byIdCache = byIdCache;
    }

    public Response<String> apply(AccountResource rsrc, Input input) throws ResourceNotFoundException, OrmException {
        Account a = this.dbProvider.get().accounts().get(rsrc.getUser().getAccountId());
        if (a == null) {
            throw new ResourceNotFoundException("account not found");
        }
        if (a.isActive()) {
            return Response.ok("");
        }
        a.setActive(true);
        this.dbProvider.get().accounts().update(Collections.singleton(a));
        this.byIdCache.evict(a.getId());
        return Response.created("");
    }

    public static class Input {
    }
}

