/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetDiffPreferences;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;

public class SetDiffPreferences
implements RestModifyView<AccountResource, Input> {
    private final Provider<CurrentUser> self;
    private final ReviewDb db;

    @Inject
    SetDiffPreferences(Provider<CurrentUser> self, ReviewDb db) {
        this.self = self;
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetDiffPreferences.DiffPreferencesInfo apply(AccountResource rsrc, Input input) throws AuthException, OrmException {
        AccountDiffPreference p;
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("restricted to administrator");
        }
        if (input == null) {
            input = new Input();
        }
        Account.Id accountId = rsrc.getUser().getAccountId();
        this.db.accounts().beginTransaction(accountId);
        try {
            p = this.db.accountDiffPreferences().get(accountId);
            if (p == null) {
                p = new AccountDiffPreference(accountId);
            }
            if (input.context != null) {
                p.setContext(input.context);
            }
            if (input.ignoreWhitespace != null) {
                p.setIgnoreWhitespace(input.ignoreWhitespace);
            }
            if (input.expandAllComments != null) {
                p.setExpandAllComments(input.expandAllComments);
            }
            if (input.intralineDifference != null) {
                p.setIntralineDifference(input.intralineDifference);
            }
            if (input.lineLength != null) {
                p.setLineLength(input.lineLength);
            }
            if (input.manualReview != null) {
                p.setManualReview(input.manualReview);
            }
            if (input.retainHeader != null) {
                p.setRetainHeader(input.retainHeader);
            }
            if (input.showLineEndings != null) {
                p.setShowLineEndings(input.showLineEndings);
            }
            if (input.showTabs != null) {
                p.setShowTabs(input.showTabs);
            }
            if (input.showWhitespaceErrors != null) {
                p.setShowWhitespaceErrors(input.showWhitespaceErrors);
            }
            if (input.skipDeleted != null) {
                p.setSkipDeleted(input.skipDeleted);
            }
            if (input.skipUncommented != null) {
                p.setSkipUncommented(input.skipUncommented);
            }
            if (input.syntaxHighlighting != null) {
                p.setSyntaxHighlighting(input.syntaxHighlighting);
            }
            if (input.hideTopMenu != null) {
                p.setHideTopMenu(input.hideTopMenu);
            }
            if (input.hideLineNumbers != null) {
                p.setHideLineNumbers(input.hideLineNumbers);
            }
            if (input.renderEntireFile != null) {
                p.setRenderEntireFile(input.renderEntireFile);
            }
            if (input.tabSize != null) {
                p.setTabSize(input.tabSize);
            }
            if (input.theme != null) {
                p.setTheme(input.theme);
            }
            this.db.accountDiffPreferences().upsert(Collections.singleton(p));
            this.db.commit();
        }
        finally {
            this.db.rollback();
        }
        return GetDiffPreferences.DiffPreferencesInfo.parse(p);
    }

    static class Input {
        Short context;
        Boolean expandAllComments;
        AccountDiffPreference.Whitespace ignoreWhitespace;
        Boolean intralineDifference;
        Integer lineLength;
        Boolean manualReview;
        Boolean retainHeader;
        Boolean showLineEndings;
        Boolean showTabs;
        Boolean showWhitespaceErrors;
        Boolean skipDeleted;
        Boolean skipUncommented;
        Boolean syntaxHighlighting;
        Boolean hideTopMenu;
        Boolean hideLineNumbers;
        Boolean renderEntireFile;
        Integer tabSize;
        AccountDiffPreference.Theme theme;

        Input() {
        }
    }
}

