/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGeneralPreferences;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetPreferences;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;

public class SetPreferences
implements RestModifyView<AccountResource, Input> {
    private final Provider<CurrentUser> self;
    private final AccountCache cache;
    private final ReviewDb db;

    @Inject
    SetPreferences(Provider<CurrentUser> self, AccountCache cache, ReviewDb db) {
        this.self = self;
        this.cache = cache;
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetPreferences.PreferenceInfo apply(AccountResource rsrc, Input i) throws AuthException, ResourceNotFoundException, OrmException {
        AccountGeneralPreferences p;
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("restricted to administrator");
        }
        if (i == null) {
            i = new Input();
        }
        Account.Id accountId = rsrc.getUser().getAccountId();
        this.db.accounts().beginTransaction(accountId);
        try {
            Account a = this.db.accounts().get(accountId);
            if (a == null) {
                throw new ResourceNotFoundException();
            }
            p = a.getGeneralPreferences();
            if (p == null) {
                p = new AccountGeneralPreferences();
                a.setGeneralPreferences(p);
            }
            if (i.changesPerPage != null) {
                p.setMaximumPageSize(i.changesPerPage);
            }
            if (i.showSiteHeader != null) {
                p.setShowSiteHeader(i.showSiteHeader);
            }
            if (i.useFlashClipboard != null) {
                p.setUseFlashClipboard(i.useFlashClipboard);
            }
            if (i.downloadScheme != null) {
                p.setDownloadUrl(i.downloadScheme);
            }
            if (i.downloadCommand != null) {
                p.setDownloadCommand(i.downloadCommand);
            }
            if (i.copySelfOnEmail != null) {
                p.setCopySelfOnEmails(i.copySelfOnEmail);
            }
            if (i.dateFormat != null) {
                p.setDateFormat(i.dateFormat);
            }
            if (i.timeFormat != null) {
                p.setTimeFormat(i.timeFormat);
            }
            if (i.reversePatchSetOrder != null) {
                p.setReversePatchSetOrder(i.reversePatchSetOrder);
            }
            if (i.showUsernameInReviewCategory != null) {
                p.setShowUsernameInReviewCategory(i.showUsernameInReviewCategory);
            }
            if (i.relativeDateInChangeTable != null) {
                p.setRelativeDateInChangeTable(i.relativeDateInChangeTable);
            }
            if (i.sizeBarInChangeTable != null) {
                p.setSizeBarInChangeTable(i.sizeBarInChangeTable);
            }
            if (i.commentVisibilityStrategy != null) {
                p.setCommentVisibilityStrategy(i.commentVisibilityStrategy);
            }
            if (i.diffView != null) {
                p.setDiffView(i.diffView);
            }
            if (i.changeScreen != null) {
                p.setChangeScreen(i.changeScreen);
            }
            this.db.accounts().update(Collections.singleton(a));
            this.db.commit();
            this.cache.evict(accountId);
        }
        finally {
            this.db.rollback();
        }
        return new GetPreferences.PreferenceInfo(p);
    }

    static class Input {
        Short changesPerPage;
        Boolean showSiteHeader;
        Boolean useFlashClipboard;
        AccountGeneralPreferences.DownloadScheme downloadScheme;
        AccountGeneralPreferences.DownloadCommand downloadCommand;
        Boolean copySelfOnEmail;
        AccountGeneralPreferences.DateFormat dateFormat;
        AccountGeneralPreferences.TimeFormat timeFormat;
        Boolean reversePatchSetOrder;
        Boolean showUsernameInReviewCategory;
        Boolean relativeDateInChangeTable;
        Boolean sizeBarInChangeTable;
        AccountGeneralPreferences.CommentVisibilityStrategy commentVisibilityStrategy;
        AccountGeneralPreferences.DiffView diffView;
        AccountGeneralPreferences.ChangeScreen changeScreen;

        Input() {
        }
    }
}

