/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.AbandonInput;
import com.google.gerrit.extensions.api.changes.AddReviewerInput;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.Changes;
import com.google.gerrit.extensions.api.changes.RestoreInput;
import com.google.gerrit.extensions.api.changes.RevertInput;
import com.google.gerrit.extensions.api.changes.RevisionApi;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.ListChangesOption;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.api.changes.ChangeInfoMapper;
import com.google.gerrit.server.api.changes.RevisionApiImpl;
import com.google.gerrit.server.change.Abandon;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.PostReviewers;
import com.google.gerrit.server.change.Restore;
import com.google.gerrit.server.change.Revert;
import com.google.gerrit.server.change.Revisions;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.EnumSet;

class ChangeApiImpl
implements ChangeApi {
    private final Changes changeApi;
    private final Revisions revisions;
    private final RevisionApiImpl.Factory revisionApi;
    private final ChangeResource change;
    private final Provider<Abandon> abandon;
    private final Provider<Revert> revert;
    private final Provider<Restore> restore;
    private final Provider<PostReviewers> postReviewers;
    private final ChangeJson changeJson;

    @Inject
    ChangeApiImpl(Changes changeApi, Revisions revisions, RevisionApiImpl.Factory revisionApi, Provider<Abandon> abandon, Provider<Revert> revert, Provider<Restore> restore, Provider<PostReviewers> postReviewers, ChangeJson changeJson, @Assisted ChangeResource change) {
        this.changeApi = changeApi;
        this.revert = revert;
        this.revisions = revisions;
        this.revisionApi = revisionApi;
        this.abandon = abandon;
        this.restore = restore;
        this.postReviewers = postReviewers;
        this.changeJson = changeJson;
        this.change = change;
    }

    @Override
    public String id() {
        return Integer.toString(this.change.getChange().getId().get());
    }

    @Override
    public RevisionApi current() throws RestApiException {
        return this.revision("current");
    }

    @Override
    public RevisionApi revision(int id) throws RestApiException {
        return this.revision(String.valueOf(id));
    }

    @Override
    public RevisionApi revision(String id) throws RestApiException {
        try {
            return this.revisionApi.create(this.revisions.parse(this.change, IdString.fromDecoded(id)));
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot parse revision", e);
        }
    }

    @Override
    public void abandon() throws RestApiException {
        this.abandon(new AbandonInput());
    }

    @Override
    public void abandon(AbandonInput in) throws RestApiException {
        try {
            this.abandon.get().apply(this.change, in);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot abandon change", e);
        }
    }

    @Override
    public void restore() throws RestApiException {
        this.restore(new RestoreInput());
    }

    @Override
    public void restore(RestoreInput in) throws RestApiException {
        try {
            this.restore.get().apply(this.change, in);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot restore change", e);
        }
    }

    @Override
    public ChangeApi revert() throws RestApiException {
        return this.revert(new RevertInput());
    }

    @Override
    public ChangeApi revert(RevertInput in) throws RestApiException {
        try {
            return this.changeApi.id(this.revert.get().apply((ChangeResource)this.change, (RevertInput)in)._number);
        }
        catch (EmailException | OrmException | IOException e) {
            throw new RestApiException("Cannot revert change", e);
        }
    }

    @Override
    public void addReviewer(String reviewer) throws RestApiException {
        AddReviewerInput in = new AddReviewerInput();
        in.reviewer = reviewer;
        this.addReviewer(in);
    }

    @Override
    public void addReviewer(AddReviewerInput in) throws RestApiException {
        try {
            this.postReviewers.get().apply(this.change, in);
        }
        catch (EmailException | OrmException | IOException e) {
            throw new RestApiException("Cannot add change reviewer", e);
        }
    }

    @Override
    public ChangeInfo get(EnumSet<ListChangesOption> s) throws RestApiException {
        try {
            return new ChangeInfoMapper(s).map(this.changeJson.addOptions(s).format(this.change));
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve change", e);
        }
    }

    @Override
    public ChangeInfo get() throws RestApiException {
        return this.get(EnumSet.allOf(ListChangesOption.class));
    }

    @Override
    public ChangeInfo info() throws RestApiException {
        return this.get(EnumSet.noneOf(ListChangesOption.class));
    }

    static interface Factory {
        public ChangeApiImpl create(ChangeResource var1);
    }
}

