/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.extensions.common.ApprovalInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.ChangeMessageInfo;
import com.google.gerrit.extensions.common.ChangeStatus;
import com.google.gerrit.extensions.common.LabelInfo;
import com.google.gerrit.extensions.common.ListChangesOption;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.account.AccountInfo;
import com.google.gerrit.server.change.ChangeJson;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;

class ChangeInfoMapper {
    private static final ImmutableMap<Change.Status, ChangeStatus> MAP = Maps.immutableEnumMap(ImmutableMap.of(Change.Status.DRAFT, ChangeStatus.DRAFT, Change.Status.NEW, ChangeStatus.NEW, Change.Status.SUBMITTED, ChangeStatus.SUBMITTED, Change.Status.MERGED, ChangeStatus.MERGED, Change.Status.ABANDONED, ChangeStatus.ABANDONED));
    private final EnumSet<ListChangesOption> s;

    ChangeInfoMapper(EnumSet<ListChangesOption> s) {
        this.s = s;
    }

    ChangeInfo map(ChangeJson.ChangeInfo i) {
        ChangeInfo o = new ChangeInfo();
        this.mapCommon(i, o);
        if (this.has(ListChangesOption.LABELS) || this.has(ListChangesOption.DETAILED_LABELS)) {
            this.mapLabels(i, o);
        }
        if (this.has(ListChangesOption.MESSAGES)) {
            this.mapMessages(i, o);
        }
        if (this.has(ListChangesOption.ALL_REVISIONS) || this.has(ListChangesOption.CURRENT_REVISION)) {
            o.revisions = i.revisions;
        }
        if (this.has(ListChangesOption.CURRENT_ACTIONS)) {
            o.actions = i.actions;
        }
        return o;
    }

    private void mapCommon(ChangeJson.ChangeInfo i, ChangeInfo o) {
        o.id = i.id;
        o.project = i.project;
        o.branch = i.branch;
        o.topic = i.topic;
        o.changeId = i.changeId;
        o.subject = i.subject;
        o.status = MAP.get((Object)i.status);
        o.created = i.created;
        o.updated = i.updated;
        o.starred = i.starred;
        o.reviewed = i.reviewed;
        o.mergeable = i.mergeable;
        o.insertions = i.insertions;
        o.deletions = i.deletions;
        o.owner = ChangeInfoMapper.fromAcountInfo(i.owner);
        o.currentRevision = i.currentRevision;
    }

    private void mapMessages(ChangeJson.ChangeInfo i, ChangeInfo o) {
        ArrayList<ChangeMessageInfo> r = Lists.newArrayListWithCapacity(i.messages.size());
        for (ChangeJson.ChangeMessageInfo m : i.messages) {
            ChangeMessageInfo cmi = new ChangeMessageInfo();
            cmi.id = m.id;
            cmi.author = ChangeInfoMapper.fromAcountInfo(m.author);
            cmi.date = m.date;
            cmi.message = m.message;
            cmi._revisionNumber = m._revisionNumber;
            r.add(cmi);
        }
        o.messages = r;
    }

    private void mapLabels(ChangeJson.ChangeInfo i, ChangeInfo o) {
        LinkedHashMap<String, LabelInfo> r = Maps.newLinkedHashMap();
        for (Map.Entry<String, ChangeJson.LabelInfo> e : i.labels.entrySet()) {
            ChangeJson.LabelInfo li = e.getValue();
            LabelInfo lo = new LabelInfo();
            lo.approved = ChangeInfoMapper.fromAcountInfo(li.approved);
            lo.rejected = ChangeInfoMapper.fromAcountInfo(li.rejected);
            lo.recommended = ChangeInfoMapper.fromAcountInfo(li.recommended);
            lo.disliked = ChangeInfoMapper.fromAcountInfo(li.disliked);
            lo.value = li.value;
            lo.optional = li.optional;
            lo.blocking = li.blocking;
            lo.values = li.values;
            if (li.all != null) {
                lo.all = Lists.newArrayListWithExpectedSize(li.all.size());
                for (ChangeJson.ApprovalInfo ai : li.all) {
                    lo.all.add(ChangeInfoMapper.fromApprovalInfo(ai));
                }
            }
            r.put(e.getKey(), lo);
        }
        o.labels = r;
    }

    private boolean has(ListChangesOption o) {
        return this.s.contains((Object)o);
    }

    private static ApprovalInfo fromApprovalInfo(ChangeJson.ApprovalInfo ai) {
        ApprovalInfo ao = new ApprovalInfo();
        ao.value = ai.value;
        ao.date = ai.date;
        ChangeInfoMapper.fromAccount(ai, ao);
        return ao;
    }

    private static com.google.gerrit.extensions.common.AccountInfo fromAcountInfo(AccountInfo i) {
        if (i == null) {
            return null;
        }
        com.google.gerrit.extensions.common.AccountInfo ai = new com.google.gerrit.extensions.common.AccountInfo();
        ChangeInfoMapper.fromAccount(i, ai);
        return ai;
    }

    private static void fromAccount(AccountInfo i, com.google.gerrit.extensions.common.AccountInfo ai) {
        ai._accountId = i._accountId;
        ai.email = i.email;
        ai.name = i.name;
        ai.username = i.username;
    }
}

