/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.projects;

import com.google.gerrit.extensions.api.projects.ProjectApi;
import com.google.gerrit.extensions.api.projects.Projects;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.server.api.projects.ProjectApiImpl;
import com.google.gerrit.server.project.ProjectsCollection;
import com.google.inject.Inject;
import java.io.IOException;

class ProjectsImpl
implements Projects {
    private final ProjectsCollection projects;
    private final ProjectApiImpl.Factory api;

    @Inject
    ProjectsImpl(ProjectsCollection projects, ProjectApiImpl.Factory api) {
        this.projects = projects;
        this.api = api;
    }

    @Override
    public ProjectApi name(String name) throws RestApiException {
        try {
            return this.api.create(this.projects.parse(name));
        }
        catch (UnprocessableEntityException | IOException e) {
            throw new RestApiException("Cannot retrieve project");
        }
    }
}

