/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.args4j;

import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class AccountGroupUUIDHandler
extends OptionHandler<AccountGroup.UUID> {
    private final GroupBackend groupBackend;

    @Inject
    public AccountGroupUUIDHandler(GroupBackend groupBackend, @Assisted CmdLineParser parser, @Assisted OptionDef option, @Assisted Setter<AccountGroup.UUID> setter) {
        super(parser, option, setter);
        this.groupBackend = groupBackend;
    }

    @Override
    public final int parseArguments(Parameters params) throws CmdLineException {
        String n = params.getParameter(0);
        GroupReference group = GroupBackends.findBestSuggestion(this.groupBackend, n);
        if (group == null) {
            throw new CmdLineException(this.owner, "Group \"" + n + "\" does not exist");
        }
        this.setter.addValue(group.getUUID());
        return 1;
    }

    @Override
    public final String getDefaultMetaVariable() {
        return "GROUP";
    }
}

