/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.args4j;

import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Iterator;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class ChangeIdHandler
extends OptionHandler<Change.Id> {
    @Inject
    private ReviewDb db;

    @Inject
    public ChangeIdHandler(ReviewDb db, @Assisted CmdLineParser parser, @Assisted OptionDef option, @Assisted Setter<Change.Id> setter) {
        super(parser, option, setter);
        this.db = db;
    }

    @Override
    public final int parseArguments(Parameters params) throws CmdLineException {
        String token = params.getParameter(0);
        String[] tokens = token.split(",");
        if (tokens.length != 3) {
            throw new CmdLineException(this.owner, "change should be specified as <project>,<branch>,<change-id>");
        }
        try {
            Change.Key key = Change.Key.parse(tokens[2]);
            Project.NameKey project = new Project.NameKey(tokens[0]);
            Branch.NameKey branch = new Branch.NameKey(project, "refs/heads/" + tokens[1]);
            Iterator<Change> i$ = this.db.changes().byBranchKey(branch, key).iterator();
            if (i$.hasNext()) {
                Change change = i$.next();
                this.setter.addValue(change.getId());
                return 1;
            }
        }
        catch (IllegalArgumentException e) {
            throw new CmdLineException(this.owner, "Change-Id is not valid");
        }
        catch (OrmException e) {
            throw new CmdLineException(this.owner, "Database error: " + e.getMessage());
        }
        throw new CmdLineException(this.owner, "\"" + token + "\": change not found");
    }

    @Override
    public final String getDefaultMetaVariable() {
        return "CHANGE";
    }
}

