/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth;

import com.google.common.base.Objects;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.server.auth.AuthException;
import com.google.gerrit.server.auth.InvalidCredentialsException;

public abstract class AuthRequest {
    private final String username;
    private final String password;

    protected AuthRequest(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Nullable
    public final String getUsername() {
        return this.username;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public void checkPassword(String pwd) throws AuthException {
        if (!Objects.equal(this.getPassword(), pwd)) {
            throw new InvalidCredentialsException();
        }
    }
}

