/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth.ldap;

import com.google.gerrit.common.data.ParameterizedString;
import com.google.gerrit.server.auth.ldap.SearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

class LdapQuery {
    static final Set<String> ALL_ATTRIBUTES = null;
    private final String base;
    private final SearchScope searchScope;
    private final ParameterizedString pattern;
    private final String[] returnAttributes;

    LdapQuery(String base, SearchScope searchScope, ParameterizedString pattern, Set<String> returnAttributes) {
        this.base = base;
        this.searchScope = searchScope;
        this.pattern = pattern;
        if (returnAttributes != null) {
            this.returnAttributes = new String[returnAttributes.size()];
            returnAttributes.toArray(this.returnAttributes);
        } else {
            this.returnAttributes = null;
        }
    }

    List<String> getParameters() {
        return this.pattern.getParameterNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Result> query(DirContext ctx, Map<String, String> params) throws NamingException {
        SearchControls sc = new SearchControls();
        sc.setSearchScope(this.searchScope.scope());
        sc.setReturningAttributes(this.returnAttributes);
        try (NamingEnumeration<SearchResult> res = ctx.search(this.base, this.pattern.getRawPattern(), (Object[])this.pattern.bind(params), sc);){
            ArrayList<Result> r = new ArrayList<Result>();
            try {
                while (res.hasMore()) {
                    r.add(new Result(res.next()));
                }
            }
            catch (PartialResultException e) {
                // empty catch block
            }
            ArrayList<Result> arrayList = r;
            return arrayList;
        }
    }

    class Result {
        private final Map<String, Attribute> atts = new HashMap<String, Attribute>();

        Result(SearchResult sr) {
            if (LdapQuery.this.returnAttributes != null) {
                for (String attName : LdapQuery.this.returnAttributes) {
                    Attribute a = sr.getAttributes().get(attName);
                    if (a == null || a.size() <= 0) continue;
                    this.atts.put(attName, a);
                }
            } else {
                NamingEnumeration<? extends Attribute> e = sr.getAttributes().getAll();
                while (e.hasMoreElements()) {
                    Attribute a = (Attribute)e.nextElement();
                    this.atts.put(a.getID(), a);
                }
            }
            this.atts.put("dn", new BasicAttribute("dn", sr.getNameInNamespace()));
        }

        String getDN() throws NamingException {
            return this.get("dn");
        }

        String get(String attName) throws NamingException {
            Attribute att = this.getAll(attName);
            return att != null && 0 < att.size() ? String.valueOf(att.get(0)) : null;
        }

        Attribute getAll(String attName) {
            return this.atts.get(attName);
        }

        Set<String> attributes() {
            return Collections.unmodifiableSet(this.atts.keySet());
        }

        public String toString() {
            try {
                return this.getDN();
            }
            catch (NamingException e) {
                return "";
            }
        }
    }
}

