/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;

public class ChangeTriplet {
    private final Change.Key changeKey;
    private final Project.NameKey projectNameKey;
    private final Branch.NameKey branchNameKey;

    public ChangeTriplet(String triplet) throws ParseException {
        int t2 = triplet.lastIndexOf(126);
        int t1 = triplet.lastIndexOf(126, t2 - 1);
        if (t1 < 0 || t2 < 0) {
            throw new ParseException();
        }
        String project = Url.decode(triplet.substring(0, t1));
        String branch = Url.decode(triplet.substring(t1 + 1, t2));
        String changeId = Url.decode(triplet.substring(t2 + 1));
        if (!branch.startsWith("refs/")) {
            branch = "refs/heads/" + branch;
        }
        this.changeKey = new Change.Key(changeId);
        this.projectNameKey = new Project.NameKey(project);
        this.branchNameKey = new Branch.NameKey(this.projectNameKey, branch);
    }

    public Change.Key getChangeKey() {
        return this.changeKey;
    }

    public Branch.NameKey getBranchNameKey() {
        return this.branchNameKey;
    }

    public static String format(Change change) {
        return change.getProject().get() + "~" + change.getDest().getShortName() + "~" + change.getKey().get();
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ParseException() {
        }
    }
}

