/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.Maps;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.common.FileInfo;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListEntry;
import com.google.gerrit.server.patch.PatchListKey;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.inject.Inject;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jgit.lib.ObjectId;

public class FileInfoJson {
    private final PatchListCache patchListCache;

    @Inject
    FileInfoJson(PatchListCache patchListCache) {
        this.patchListCache = patchListCache;
    }

    Map<String, FileInfo> toFileInfoMap(Change change, PatchSet patchSet) throws PatchListNotAvailableException {
        return this.toFileInfoMap(change, patchSet, null);
    }

    Map<String, FileInfo> toFileInfoMap(Change change, PatchSet patchSet, @Nullable PatchSet base) throws PatchListNotAvailableException {
        ObjectId a = base == null ? null : ObjectId.fromString(base.getRevision().get());
        ObjectId b = ObjectId.fromString(patchSet.getRevision().get());
        PatchList list = this.patchListCache.get(new PatchListKey(change.getProject(), a, b, AccountDiffPreference.Whitespace.IGNORE_NONE));
        TreeMap<String, FileInfo> files = Maps.newTreeMap();
        for (PatchListEntry e : list.getPatches()) {
            FileInfo o;
            FileInfo d = new FileInfo();
            d.status = e.getChangeType() != Patch.ChangeType.MODIFIED ? Character.valueOf(e.getChangeType().getCode()) : null;
            d.oldPath = e.getOldName();
            if (e.getPatchType() == Patch.PatchType.BINARY) {
                d.binary = true;
            } else {
                d.linesInserted = e.getInsertions() > 0 ? Integer.valueOf(e.getInsertions()) : null;
                Integer n = d.linesDeleted = e.getDeletions() > 0 ? Integer.valueOf(e.getDeletions()) : null;
            }
            if ((o = files.put(e.getNewName(), d)) == null) continue;
            d.status = Character.valueOf(Patch.ChangeType.REWRITE.getCode());
            if (o.binary != null && o.binary.booleanValue()) {
                d.binary = true;
            }
            if (o.linesInserted != null) {
                d.linesInserted = o.linesInserted;
            }
            if (o.linesDeleted == null) continue;
            d.linesDeleted = o.linesDeleted;
        }
        return files;
    }
}

