/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gerrit.extensions.common.FileInfo;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.CacheControl;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountPatchReview;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.FileInfoJson;
import com.google.gerrit.server.change.FileResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Revisions;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Files
implements ChildCollection<RevisionResource, FileResource> {
    private final DynamicMap<RestView<FileResource>> views;
    private final Provider<ListFiles> list;

    @Inject
    Files(DynamicMap<RestView<FileResource>> views, Provider<ListFiles> list) {
        this.views = views;
        this.list = list;
    }

    @Override
    public DynamicMap<RestView<FileResource>> views() {
        return this.views;
    }

    @Override
    public RestView<RevisionResource> list() throws AuthException {
        return this.list.get();
    }

    @Override
    public FileResource parse(RevisionResource rev, IdString id) throws ResourceNotFoundException, OrmException, AuthException {
        return new FileResource(rev, id.get());
    }

    private static final class ListFiles
    implements RestReadView<RevisionResource> {
        private static final Logger log = LoggerFactory.getLogger(ListFiles.class);
        @Option(name="--base", metaVar="revision-id")
        String base;
        @Option(name="--reviewed")
        boolean reviewed;
        private final Provider<ReviewDb> db;
        private final Provider<CurrentUser> self;
        private final FileInfoJson fileInfoJson;
        private final Provider<Revisions> revisions;
        private final GitRepositoryManager gitManager;
        private final PatchListCache patchListCache;

        @Inject
        ListFiles(Provider<ReviewDb> db, Provider<CurrentUser> self, FileInfoJson fileInfoJson, Provider<Revisions> revisions, GitRepositoryManager gitManager, PatchListCache patchListCache) {
            this.db = db;
            this.self = self;
            this.fileInfoJson = fileInfoJson;
            this.revisions = revisions;
            this.gitManager = gitManager;
            this.patchListCache = patchListCache;
        }

        public Response<?> apply(RevisionResource resource) throws AuthException, BadRequestException, ResourceNotFoundException, OrmException {
            if (this.base != null && this.reviewed) {
                throw new BadRequestException("cannot combine base and reviewed");
            }
            if (this.reviewed) {
                return Response.ok(this.reviewed(resource));
            }
            PatchSet basePatchSet = null;
            if (this.base != null) {
                RevisionResource baseResource = this.revisions.get().parse(resource.getChangeResource(), IdString.fromDecoded(this.base));
                basePatchSet = baseResource.getPatchSet();
            }
            try {
                Response<Map<String, FileInfo>> r = Response.ok(this.fileInfoJson.toFileInfoMap(resource.getChange(), resource.getPatchSet(), basePatchSet));
                if (resource.isCacheable()) {
                    r.caching(CacheControl.PRIVATE(7L, TimeUnit.DAYS));
                }
                return r;
            }
            catch (PatchListNotAvailableException e) {
                throw new ResourceNotFoundException(e.getMessage());
            }
        }

        private List<String> reviewed(RevisionResource resource) throws AuthException, OrmException {
            CurrentUser user = this.self.get();
            if (!user.isIdentifiedUser()) {
                throw new AuthException("Authentication required");
            }
            Account.Id userId = ((IdentifiedUser)user).getAccountId();
            List<String> r = this.scan(userId, resource.getPatchSet().getId());
            if (r.isEmpty() && 1 < resource.getPatchSet().getPatchSetId()) {
                for (Integer id : this.reverseSortPatchSets(resource)) {
                    PatchSet.Id old = new PatchSet.Id(resource.getChange().getId(), id);
                    List<String> o = this.scan(userId, old);
                    if (o.isEmpty()) continue;
                    try {
                        r = this.copy(Sets.newHashSet(o), old, resource, userId);
                    }
                    catch (PatchListNotAvailableException | IOException e) {
                        log.warn("Cannot copy patch review flags", e);
                    }
                    break;
                }
            }
            return r;
        }

        private List<String> scan(Account.Id userId, PatchSet.Id psId) throws OrmException {
            ArrayList<String> r = Lists.newArrayList();
            for (AccountPatchReview w : this.db.get().accountPatchReviews().byReviewer(userId, psId)) {
                r.add(w.getKey().getPatchKey().getFileName());
            }
            return r;
        }

        private List<Integer> reverseSortPatchSets(RevisionResource resource) throws OrmException {
            TreeSet<Integer> ids = Sets.newTreeSet();
            for (PatchSet p : this.db.get().patchSets().byChange(resource.getChange().getId())) {
                if (p.getPatchSetId() >= resource.getPatchSet().getPatchSetId()) continue;
                ids.add(p.getPatchSetId());
            }
            ArrayList<Integer> r = Lists.newArrayList(ids);
            Collections.reverse(r);
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> copy(Set<String> paths, PatchSet.Id old, RevisionResource resource, Account.Id userId) throws IOException, PatchListNotAvailableException, OrmException {
            try (Repository git = this.gitManager.openRepository(resource.getChange().getProject());){
                ObjectReader reader = git.newObjectReader();
                try {
                    PatchList oldList = this.patchListCache.get(resource.getChange(), this.db.get().patchSets().get(old));
                    PatchList curList = this.patchListCache.get(resource.getChange(), resource.getPatchSet());
                    int sz = paths.size();
                    ArrayList<AccountPatchReview> inserts = Lists.newArrayListWithCapacity(sz);
                    ArrayList<String> pathList = Lists.newArrayListWithCapacity(sz);
                    RevWalk rw = new RevWalk(reader);
                    TreeWalk tw = new TreeWalk(reader);
                    tw.setFilter(PathFilterGroup.createFromStrings(paths));
                    tw.setRecursive(true);
                    int o = tw.addTree(rw.parseCommit(oldList.getNewId()).getTree());
                    int c = tw.addTree(rw.parseCommit(curList.getNewId()).getTree());
                    int op = -1;
                    if (oldList.getOldId() != null) {
                        op = tw.addTree(rw.parseTree(oldList.getOldId()));
                    }
                    int cp = -1;
                    if (curList.getOldId() != null) {
                        cp = tw.addTree(rw.parseTree(curList.getOldId()));
                    }
                    while (tw.next()) {
                        String path = tw.getPathString();
                        if (tw.getRawMode(o) != 0 && tw.getRawMode(c) != 0 && tw.idEqual(o, c) && paths.contains(path)) {
                            inserts.add(new AccountPatchReview(new Patch.Key(resource.getPatchSet().getId(), path), userId));
                            pathList.add(path);
                            continue;
                        }
                        if (op < 0 || cp < 0 || tw.getRawMode(o) != 0 || tw.getRawMode(c) != 0 || tw.getRawMode(op) == 0 || tw.getRawMode(cp) == 0 || !tw.idEqual(op, cp) || !paths.contains(path)) continue;
                        inserts.add(new AccountPatchReview(new Patch.Key(resource.getPatchSet().getId(), path), userId));
                        pathList.add(path);
                    }
                    this.db.get().accountPatchReviews().insert(inserts);
                    ArrayList<String> arrayList = pathList;
                    reader.release();
                    return arrayList;
                }
                catch (Throwable throwable) {
                    reader.release();
                    throw throwable;
                }
            }
        }
    }
}

