/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gerrit.common.data.IncludedInDetail;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludedInResolver {
    private static final Logger log = LoggerFactory.getLogger(IncludedInResolver.class);
    private final Repository repo;
    private final RevWalk rw;
    private final RevCommit target;
    private final RevFlag containsTarget;
    private Multimap<RevCommit, String> commitToRef;
    private List<RevCommit> tipsByCommitTime;

    public static IncludedInDetail resolve(Repository repo, RevWalk rw, RevCommit commit) throws IOException {
        return new IncludedInResolver(repo, rw, commit).resolve();
    }

    public static boolean includedInOne(Repository repo, RevWalk rw, RevCommit commit, Collection<Ref> refs) throws IOException {
        return new IncludedInResolver(repo, rw, commit).includedInOne(refs);
    }

    private IncludedInResolver(Repository repo, RevWalk rw, RevCommit target) {
        this.repo = repo;
        this.rw = rw;
        this.target = target;
        this.containsTarget = rw.newFlag("CONTAINS_TARGET");
    }

    private IncludedInDetail resolve() throws IOException {
        RefDatabase refDb = this.repo.getRefDatabase();
        Collection<Ref> tags = refDb.getRefs("refs/tags/").values();
        Collection<Ref> branches = refDb.getRefs("refs/heads/").values();
        ArrayList<Ref> allTagsAndBranches = Lists.newArrayListWithCapacity(tags.size() + branches.size());
        allTagsAndBranches.addAll(tags);
        allTagsAndBranches.addAll(branches);
        this.parseCommits(allTagsAndBranches);
        Set<String> allMatchingTagsAndBranches = this.includedIn(this.tipsByCommitTime, 0);
        IncludedInDetail detail = new IncludedInDetail();
        detail.setBranches(IncludedInResolver.getMatchingRefNames(allMatchingTagsAndBranches, branches));
        detail.setTags(IncludedInResolver.getMatchingRefNames(allMatchingTagsAndBranches, tags));
        return detail;
    }

    private boolean includedInOne(Collection<Ref> refs) throws IOException {
        this.parseCommits(refs);
        LinkedList<RevCommit> before = Lists.newLinkedList();
        LinkedList<RevCommit> after = Lists.newLinkedList();
        this.partition(before, after);
        return !this.includedIn(after, 1).isEmpty() || !this.includedIn(before, 1).isEmpty();
    }

    private Set<String> includedIn(Collection<RevCommit> tips, int limit) throws IOException, MissingObjectException, IncorrectObjectTypeException {
        HashSet<String> result = Sets.newHashSet();
        for (RevCommit tip : tips) {
            boolean commitFound = false;
            this.rw.resetRetain(RevFlag.UNINTERESTING, this.containsTarget);
            this.rw.markStart(tip);
            for (RevCommit commit : this.rw) {
                if (!commit.equals(this.target) && !commit.has(this.containsTarget)) continue;
                commitFound = true;
                tip.add(this.containsTarget);
                result.addAll(this.commitToRef.get(tip));
                break;
            }
            if (!commitFound) {
                this.rw.markUninteresting(tip);
                continue;
            }
            if (0 >= limit || limit >= result.size()) continue;
            break;
        }
        return result;
    }

    private void partition(List<RevCommit> before, List<RevCommit> after) {
        int insertionPoint = Collections.binarySearch(this.tipsByCommitTime, this.target, new Comparator<RevCommit>(){

            @Override
            public int compare(RevCommit c1, RevCommit c2) {
                return c1.getCommitTime() - c2.getCommitTime();
            }
        });
        if (insertionPoint < 0) {
            insertionPoint = -(insertionPoint + 1);
        }
        if (0 < insertionPoint) {
            before.addAll(this.tipsByCommitTime.subList(0, insertionPoint));
        }
        if (insertionPoint < this.tipsByCommitTime.size()) {
            after.addAll(this.tipsByCommitTime.subList(insertionPoint, this.tipsByCommitTime.size()));
        }
    }

    private static List<String> getMatchingRefNames(Set<String> matchingRefs, Collection<Ref> allRefs) {
        ArrayList<String> refNames = Lists.newArrayListWithCapacity(matchingRefs.size());
        for (Ref r : allRefs) {
            if (!matchingRefs.contains(r.getName())) continue;
            refNames.add(Repository.shortenRefName(r.getName()));
        }
        return refNames;
    }

    private void parseCommits(Collection<Ref> refs) throws IOException {
        if (this.commitToRef != null) {
            return;
        }
        this.commitToRef = LinkedListMultimap.create();
        for (Ref ref : refs) {
            RevCommit commit;
            try {
                commit = this.rw.parseCommit(ref.getObjectId());
            }
            catch (IncorrectObjectTypeException notCommit) {
                continue;
            }
            catch (MissingObjectException notHere) {
                log.warn("Reference " + ref.getName() + " in " + this.repo.getDirectory() + " points to dangling object " + ref.getObjectId());
                continue;
            }
            this.commitToRef.put(commit, ref.getName());
        }
        this.tipsByCommitTime = Lists.newArrayList(this.commitToRef.keySet());
        this.sortOlderFirst(this.tipsByCommitTime);
    }

    private void sortOlderFirst(List<RevCommit> tips) {
        Collections.sort(tips, new Comparator<RevCommit>(){

            @Override
            public int compare(RevCommit c1, RevCommit c2) {
                return c1.getCommitTime() - c2.getCommitTime();
            }
        });
    }
}

