/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.project.ChangeControl;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;

public class ReviewerResource
extends ChangeResource {
    public static final TypeLiteral<RestView<ReviewerResource>> REVIEWER_KIND = new TypeLiteral<RestView<ReviewerResource>>(){};
    private final IdentifiedUser user;

    @AssistedInject
    ReviewerResource(@Assisted ChangeResource rsrc, @Assisted IdentifiedUser user) {
        super(rsrc);
        this.user = user;
    }

    @AssistedInject
    ReviewerResource(IdentifiedUser.GenericFactory userFactory, @Assisted ChangeResource rsrc, @Assisted Account.Id id) {
        this(rsrc, userFactory.create(id));
    }

    public IdentifiedUser getUser() {
        return this.user;
    }

    public ChangeControl getUserControl() {
        return this.getControl().forUser(this.user);
    }

    public static interface Factory {
        public ReviewerResource create(ChangeResource var1, IdentifiedUser var2);

        public ReviewerResource create(ChangeResource var1, Account.Id var2);
    }
}

