/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ChangeControl;
import com.google.inject.TypeLiteral;

public class RevisionResource
implements RestResource,
RestResource.HasETag {
    public static final TypeLiteral<RestView<RevisionResource>> REVISION_KIND = new TypeLiteral<RestView<RevisionResource>>(){};
    private final ChangeResource change;
    private final PatchSet ps;
    private boolean cacheable = true;

    public RevisionResource(ChangeResource change, PatchSet ps) {
        this.change = change;
        this.ps = ps;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public ChangeResource getChangeResource() {
        return this.change;
    }

    public ChangeControl getControl() {
        return this.getChangeResource().getControl();
    }

    public Change getChange() {
        return this.getControl().getChange();
    }

    public ChangeNotes getNotes() {
        return this.getChangeResource().getNotes();
    }

    public PatchSet getPatchSet() {
        return this.ps;
    }

    @Override
    public String getETag() {
        return this.change.getETag();
    }

    Account.Id getAccountId() {
        return this.getUser().getAccountId();
    }

    IdentifiedUser getUser() {
        return (IdentifiedUser)this.getControl().getCurrentUser();
    }

    RevisionResource doNotCache() {
        this.cacheable = false;
        return this;
    }
}

