/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.reviewdb.client.AccountGeneralPreferences;
import com.google.gerrit.reviewdb.client.SystemConfig;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.lib.Config;

@Singleton
public class DownloadConfig {
    private final Set<AccountGeneralPreferences.DownloadScheme> downloadSchemes;
    private final Set<AccountGeneralPreferences.DownloadCommand> downloadCommands;

    @Inject
    DownloadConfig(@GerritServerConfig Config cfg, SystemConfig s) {
        List<AccountGeneralPreferences.DownloadScheme> allSchemes = ConfigUtil.getEnumList(cfg, "download", null, "scheme", AccountGeneralPreferences.DownloadScheme.DEFAULT_DOWNLOADS);
        this.downloadSchemes = Collections.unmodifiableSet(new HashSet<AccountGeneralPreferences.DownloadScheme>(allSchemes));
        List<AccountGeneralPreferences.DownloadCommand> allCommands = ConfigUtil.getEnumList(cfg, "download", null, "command", AccountGeneralPreferences.DownloadCommand.DEFAULT_DOWNLOADS);
        this.downloadCommands = Collections.unmodifiableSet(new HashSet<AccountGeneralPreferences.DownloadCommand>(allCommands));
    }

    public Set<AccountGeneralPreferences.DownloadScheme> getDownloadSchemes() {
        return this.downloadSchemes;
    }

    public Set<AccountGeneralPreferences.DownloadCommand> getDownloadCommands() {
        return this.downloadCommands;
    }
}

