/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.collect.Maps;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.GerritServerConfigProvider;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.ProjectLevelConfig;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.ReloadPluginListener;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PluginConfigFactory
implements ReloadPluginListener {
    private static final Logger log = LoggerFactory.getLogger(PluginConfigFactory.class);
    private final SitePaths site;
    private final GerritServerConfigProvider cfgProvider;
    private final ProjectCache projectCache;
    private final ProjectState.Factory projectStateFactory;
    private final Map<String, Config> pluginConfigs;
    private volatile FileSnapshot cfgSnapshot;
    private volatile Config cfg;

    @Inject
    PluginConfigFactory(SitePaths site, GerritServerConfigProvider cfgProvider, ProjectCache projectCache, ProjectState.Factory projectStateFactory) {
        this.site = site;
        this.cfgProvider = cfgProvider;
        this.projectCache = projectCache;
        this.projectStateFactory = projectStateFactory;
        this.pluginConfigs = Maps.newHashMap();
        this.cfgSnapshot = FileSnapshot.save(site.gerrit_config);
        this.cfg = cfgProvider.get();
    }

    public PluginConfig getFromGerritConfig(String pluginName) {
        return this.getFromGerritConfig(pluginName, false);
    }

    public PluginConfig getFromGerritConfig(String pluginName, boolean refresh) {
        if (refresh && this.cfgSnapshot.isModified(this.site.gerrit_config)) {
            this.cfgSnapshot = FileSnapshot.save(this.site.gerrit_config);
            this.cfg = this.cfgProvider.get();
        }
        return new PluginConfig(pluginName, this.cfg);
    }

    public PluginConfig getFromProjectConfig(Project.NameKey projectName, String pluginName) throws NoSuchProjectException {
        ProjectState projectState = this.projectCache.get(projectName);
        if (projectState == null) {
            throw new NoSuchProjectException(projectName);
        }
        return this.getFromProjectConfig(projectState, pluginName);
    }

    public PluginConfig getFromProjectConfig(ProjectState projectState, String pluginName) {
        return projectState.getConfig().getPluginConfig(pluginName);
    }

    public PluginConfig getFromProjectConfigWithInheritance(Project.NameKey projectName, String pluginName) throws NoSuchProjectException {
        return this.getFromProjectConfig(projectName, pluginName).withInheritance(this.projectStateFactory);
    }

    public PluginConfig getFromProjectConfigWithInheritance(ProjectState projectState, String pluginName) {
        return this.getFromProjectConfig(projectState, pluginName).withInheritance(this.projectStateFactory);
    }

    public synchronized Config getGlobalPluginConfig(String pluginName) {
        if (this.pluginConfigs.containsKey(pluginName)) {
            return this.pluginConfigs.get(pluginName);
        }
        File pluginConfigFile = new File(this.site.etc_dir, pluginName + ".config");
        FileBasedConfig cfg = new FileBasedConfig(pluginConfigFile, FS.DETECTED);
        this.pluginConfigs.put(pluginName, cfg);
        if (!cfg.getFile().exists()) {
            log.info("No " + pluginConfigFile.getAbsolutePath() + "; assuming defaults");
            return cfg;
        }
        try {
            cfg.load();
        }
        catch (IOException e) {
            log.warn("Failed to load " + pluginConfigFile.getAbsolutePath(), e);
        }
        catch (ConfigInvalidException e) {
            log.warn("Failed to load " + pluginConfigFile.getAbsolutePath(), e);
        }
        return cfg;
    }

    public Config getProjectPluginConfig(Project.NameKey projectName, String pluginName) throws NoSuchProjectException {
        return this.getPluginConfig(projectName, pluginName).get();
    }

    public Config getProjectPluginConfig(ProjectState projectState, String pluginName) {
        return projectState.getConfig(pluginName).get();
    }

    public Config getProjectPluginConfigWithInheritance(Project.NameKey projectName, String pluginName) throws NoSuchProjectException {
        return this.getPluginConfig(projectName, pluginName).getWithInheritance();
    }

    public Config getProjectPluginConfigWithInheritance(ProjectState projectState, String pluginName) {
        return projectState.getConfig(pluginName).getWithInheritance();
    }

    private ProjectLevelConfig getPluginConfig(Project.NameKey projectName, String pluginName) throws NoSuchProjectException {
        ProjectState projectState = this.projectCache.get(projectName);
        if (projectState == null) {
            throw new NoSuchProjectException(projectName);
        }
        return projectState.getConfig(pluginName);
    }

    @Override
    public synchronized void onReloadPlugin(Plugin oldPlugin, Plugin newPlugin) {
        this.pluginConfigs.remove(oldPlugin.getName());
    }
}

